set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9849772';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2004-5-03 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1104',
      '14113103',
      52,
      21,
      '0134440',
      NULL,
      1,
      3,
      0,
      '142100',
      3.190363,
      ' 4-20-1991',
      26,
      14,
      0,
      NULL,
      NULL,
      NULL,
      3.346369,
      1,
      1.018024,
      1,
      1.369371,
      0,
      NULL,
      1.872201,
      5,
      0,
      0,
      1,
      1.014639,
      0,
      5.574048,
      0,
      0.205619,
      1,
      1.910870,
      1.149853,
      4,
      0,
      1.198263,
      NULL,
      3,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      1,
      0.559037,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.046763,
      1.726262,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.462326,
      1.158027,
      3.545144,
      0,
      3.199391,
      1.561785,
      1,
      0.962712,
      1,
      NULL,
      0.448829,
      NULL,
      1.567390,
      0.531525,
      1.366638,
      NULL,
      NULL,
      0,
      1,
      NULL,
      1,
      5.149232,
      NULL,
      1,
      NULL,
      0.309788,
      2.455098,
      0.677477,
      NULL,
      NULL,
      NULL,
      0,
      1.095312,
      3.490750,
      4.343542,
      1.271130,
      6,
      0.474772,
      0,
      1,
      3.701659,
      NULL,
      5,
      3,
      7.516003,
      0,
      0.125897,
      1.696416,
      0,
      NULL,
      NULL,
      5,
      0.590575,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      6,
      3,
      2,
      NULL,
      1,
      1.175203,
      2,
      3,
      0.053317,
      NULL,
      NULL,
      NULL,
      1.964717,
      0.293152,
      0.058196,
      1,
      0,
      1,
      0,
      NULL,
      NULL,
      NULL,
      0.131382,
      1.219634,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.729889,
      1.039624,
      1.179616,
      NULL,
      NULL,
      0.609406,
      3.722877,
      1.655156,
      1.646434,
      0.409894,
      0,
      0.550912,
      0.432377,
      3,
      2.465195,
      NULL,
      0,
      1,
      3.852545,
      0.253004,
      NULL,
      0.137777,
      2.683959,
      3.878680,
      NULL,
      NULL,
      NULL,
      0.645026,
      1,
      NULL,
      1,
      1,
      0.011123,
      1,
      0,
      1,
      NULL,
      0.001191,
      1,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2.433383,
      '30340',
      '34303',
      '43124',
      NULL,
      '',
      '',
      NULL,
      0,
      '1334',
      '',
      '',
      2,
      NULL,
      2.695825,
      0.620308,
      6,
      2,
      1.008425,
      2.373365,
      1);
commit;
end;
/


