set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9849772';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2005-5-26 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '31012242',
      NULL,
      27,
      '1401131',
      47,
      1,
      0.084308,
      3,
      '140341',
      5.030191,
      ' 3-15-1997',
      40.220165,
      43.375130,
      0,
      NULL,
      1.888831,
      1,
      1,
      NULL,
      1.003826,
      NULL,
      1.467949,
      1,
      1.764956,
      1,
      6,
      0.888609,
      1.457430,
      1.640093,
      1,
      0.745032,
      2,
      0,
      1,
      1.904940,
      3.688670,
      1,
      2,
      0,
      1,
      0,
      1.607171,
      0.689318,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3.893789,
      1,
      1.165718,
      0,
      0.764485,
      1.065299,
      NULL,
      2.760012,
      0,
      1,
      1,
      0,
      0,
      0,
      0.476004,
      0.188428,
      1.407728,
      0.841813,
      1.070445,
      2.668434,
      0.700454,
      1,
      5,
      1,
      NULL,
      2.574971,
      0.940802,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      0,
      NULL,
      0.298568,
      2,
      1,
      1,
      1.732746,
      0.627377,
      NULL,
      1,
      1,
      NULL,
      0,
      0,
      1.870311,
      0.463625,
      1.818073,
      1,
      NULL,
      0.254674,
      NULL,
      0.480487,
      0,
      0,
      0,
      1.977421,
      0,
      0.408061,
      3.534372,
      5,
      1.252332,
      3,
      0.621346,
      NULL,
      1.136437,
      2,
      6,
      NULL,
      7,
      NULL,
      3,
      7.769082,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      2,
      1,
      NULL,
      4,
      1.570782,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.549785,
      0.330051,
      1,
      0,
      1,
      1,
      0,
      1.928222,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0.029952,
      1.746296,
      3,
      NULL,
      2.506943,
      0.869892,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.376590,
      4.856574,
      2,
      2,
      4.138731,
      1,
      NULL,
      NULL,
      NULL,
      6.446198,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2,
      2.793294,
      3.833455,
      0,
      0.534207,
      0,
      NULL,
      0,
      0.345097,
      0.696089,
      0.645897,
      0,
      1.747559,
      NULL,
      0,
      0.785321,
      NULL,
      0.784467,
      0.721526,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      5.211470,
      '11243',
      '31022',
      NULL,
      NULL,
      '',
      NULL,
      '',
      NULL,
      '3324',
      '',
      '',
      0.852465,
      3,
      1,
      2,
      3.357209,
      NULL,
      3,
      0,
      3);
commit;
end;
/


