set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7942292';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2004-5-07 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4030',
      '20021400',
      4,
      34,
      '2330023',
      14,
      2,
      1,
      0,
      '231224',
      6,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.456733,
      0.251380,
      0,
      NULL,
      0.361150,
      0,
      1,
      1.770757,
      1.087426,
      1,
      NULL,
      0,
      1.359734,
      0.794141,
      NULL,
      1.456022,
      NULL,
      0.369636,
      0,
      NULL,
      1.579592,
      NULL,
      0.193024,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.703952,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.525749,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.664182,
      NULL,
      1.052643,
      4,
      NULL,
      0.425345,
      0,
      1,
      1.455292,
      1.956779,
      1,
      0,
      1.708816,
      0.499458,
      0.909061,
      1.902701,
      0,
      0,
      NULL,
      1.095455,
      1,
      1,
      0.326604,
      0.815445,
      1,
      1.819756,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0.053889,
      0,
      NULL,
      0.325504,
      NULL,
      1.456634,
      1.983407,
      1,
      0.126113,
      4,
      NULL,
      1,
      2.013055,
      1.470569,
      4,
      4.949766,
      1,
      NULL,
      NULL,
      0.053781,
      1.278688,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.274292,
      1.720586,
      0,
      0,
      0.085838,
      0,
      0.464004,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      3.299423,
      3,
      1,
      NULL,
      0,
      2.950924,
      0.019825,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.824536,
      0.942748,
      1,
      1,
      1,
      1,
      0.927154,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.448453,
      0,
      0.528400,
      0,
      0.221261,
      1.583516,
      1,
      NULL,
      0,
      0,
      NULL,
      NULL,
      1,
      0,
      NULL,
      0.533624,
      1,
      0.211516,
      1.321116,
      1.826015,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.313421,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.043023,
      NULL,
      '',
      '',
      0,
      '',
      NULL,
      '',
      NULL,
      '',
      '',
      '',
      4.096865,
      5.643256,
      0.127870,
      3,
      NULL,
      2.721446,
      NULL,
      NULL,
      1.053772);
commit;
end;
/


