set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9101607';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1996-3-26 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0',
      '1',
      NULL,
      NULL,
      '2231010',
      25,
      5,
      2,
      0,
      '144402',
      0.270703,
      ' 2- 6-2000',
      NULL,
      NULL,
      1,
      NULL,
      1,
      3,
      1,
      0,
      0,
      1,
      1,
      0,
      3,
      1,
      5,
      0,
      2,
      0.579719,
      7,
      1.919194,
      3.045712,
      3.177593,
      0.136863,
      1,
      5.317894,
      NULL,
      7.155797,
      1,
      5,
      1,
      2,
      0.869778,
      NULL,
      NULL,
      NULL,
      5,
      2.080420,
      0.850550,
      1.758803,
      0.982996,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2.514747,
      NULL,
      1,
      0,
      1.905804,
      1.946830,
      NULL,
      NULL,
      3,
      NULL,
      0.970935,
      NULL,
      0.657910,
      NULL,
      1.008021,
      NULL,
      NULL,
      1.362795,
      1.951382,
      1.432985,
      1,
      2.083781,
      0,
      1.781465,
      5.104705,
      1.226702,
      0,
      0.753367,
      0,
      NULL,
      NULL,
      0.668504,
      2,
      0.370038,
      NULL,
      1.476354,
      0.178747,
      0.510106,
      0,
      1.575519,
      NULL,
      2.468353,
      1.269283,
      2.302057,
      1.041286,
      1.733866,
      1,
      NULL,
      3,
      4,
      6,
      6,
      NULL,
      2,
      6,
      1.788327,
      NULL,
      1,
      5,
      2,
      0,
      1.743233,
      7.393635,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      2,
      2,
      NULL,
      0.182913,
      1.450169,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      8,
      NULL,
      NULL,
      3.198812,
      1,
      1,
      0.557401,
      0.731348,
      3.752353,
      NULL,
      1.907234,
      4.175282,
      1,
      1,
      1,
      3.280167,
      3.795733,
      9,
      NULL,
      5.717415,
      2.392474,
      6,
      0,
      0,
      0,
      NULL,
      NULL,
      2,
      4.522837,
      1.759787,
      NULL,
      4,
      7,
      0,
      NULL,
      0,
      0.839633,
      NULL,
      0,
      0.146841,
      1,
      1,
      0,
      2,
      0,
      1,
      3,
      0.639580,
      0,
      0.077912,
      1,
      1,
      1,
      0,
      0,
      0.309519,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.391162,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.553103,
      NULL,
      '',
      '',
      NULL,
      '',
      '',
      '',
      1,
      '',
      '',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


