set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9101607';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1998-3-02 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '034',
      '20',
      5,
      25.607266,
      NULL,
      57.745243,
      5,
      1,
      1,
      '032431',
      4,
      ' 3- 8-1999',
      1,
      38.837051,
      0.975153,
      NULL,
      1.750851,
      1.819334,
      1,
      1.521345,
      1,
      3.606891,
      0.382110,
      0,
      NULL,
      0,
      2.263224,
      1,
      3.938560,
      0.298447,
      NULL,
      1,
      0,
      5,
      0,
      1.380405,
      4.480033,
      1,
      NULL,
      1,
      0,
      0.758290,
      1,
      NULL,
      NULL,
      NULL,
      1.732237,
      NULL,
      NULL,
      3.150173,
      NULL,
      1,
      1.408566,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.430565,
      NULL,
      2,
      4,
      NULL,
      0,
      1.258182,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      1,
      0,
      NULL,
      3,
      NULL,
      1,
      0,
      NULL,
      NULL,
      0.483342,
      0,
      1.249315,
      2,
      NULL,
      0.933501,
      1.727634,
      1,
      0.368505,
      NULL,
      3,
      4,
      1,
      1.693904,
      1,
      1.546279,
      0,
      1.561094,
      4,
      1.975671,
      0,
      1.947375,
      NULL,
      1.132989,
      NULL,
      1.245062,
      0.417249,
      3,
      2.383916,
      5.379679,
      2,
      6,
      1,
      NULL,
      NULL,
      5.092800,
      0,
      4.415584,
      1.722229,
      NULL,
      NULL,
      NULL,
      0.536032,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.830222,
      NULL,
      1,
      0,
      NULL,
      1.961814,
      0.736227,
      0.274765,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      4.239108,
      1.080817,
      0.422169,
      1.397424,
      1.605662,
      4,
      1.600238,
      3.629660,
      1,
      NULL,
      NULL,
      NULL,
      0,
      1,
      4.580652,
      NULL,
      7.356330,
      0,
      1.490847,
      NULL,
      NULL,
      NULL,
      1.176071,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.956025,
      1,
      1,
      0.182263,
      0.601830,
      3,
      1,
      2,
      0.721215,
      0,
      3,
      NULL,
      0,
      NULL,
      NULL,
      0.728664,
      1.922648,
      0,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.224781,
      '42040',
      '42143',
      '',
      0,
      '',
      '',
      '',
      0.511033,
      '',
      '',
      '',
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


