set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9101607';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1998-10-27 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '134',
      '04',
      NULL,
      NULL,
      '3130013',
      70,
      2,
      0,
      NULL,
      '231044',
      0.244722,
      NULL,
      41,
      37.106499,
      0.506229,
      NULL,
      1,
      1.341281,
      1.994068,
      1.378888,
      0.281035,
      1,
      0,
      0,
      3.445494,
      0.875515,
      0.407940,
      NULL,
      1.578188,
      0,
      5.780840,
      1,
      0,
      NULL,
      1.030532,
      0,
      NULL,
      0.400849,
      1,
      0,
      NULL,
      1,
      NULL,
      0,
      NULL,
      NULL,
      1.882263,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.101656,
      NULL,
      1,
      3,
      0,
      NULL,
      0.452056,
      0,
      NULL,
      NULL,
      1.538664,
      NULL,
      NULL,
      1.253055,
      1.763344,
      0,
      2.713391,
      1.061231,
      0,
      0.669012,
      1,
      1.973560,
      NULL,
      1,
      NULL,
      0.285063,
      1.277889,
      NULL,
      1,
      1,
      0.704456,
      1.352941,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.189844,
      0,
      2.616235,
      NULL,
      2,
      NULL,
      NULL,
      0,
      NULL,
      3,
      0.625076,
      0.715778,
      NULL,
      4.511762,
      4,
      NULL,
      NULL,
      2,
      7.353520,
      5.714795,
      1,
      NULL,
      1,
      3.817573,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.807098,
      NULL,
      0,
      0,
      1,
      1.953752,
      1.241193,
      1.209020,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.491129,
      NULL,
      NULL,
      NULL,
      NULL,
      0.767275,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0,
      0,
      NULL,
      NULL,
      NULL,
      3,
      1.088250,
      2,
      3,
      5.834983,
      0,
      0.644165,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.225563,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0,
      1.032656,
      2.844144,
      NULL,
      NULL,
      3.528060,
      0,
      3.263940,
      3.004452,
      1.305278,
      0.574459,
      NULL,
      0.994304,
      1,
      0.328906,
      0,
      NULL,
      1.856752,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.144152,
      NULL,
      '20304',
      '',
      NULL,
      NULL,
      '',
      '',
      1.822621,
      '',
      '',
      '',
      5.242729,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


