set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9101607';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1999-3-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '313',
      '23',
      19.176945,
      NULL,
      '3010303',
      161,
      1,
      3.271755,
      2,
      '033031',
      0.872240,
      NULL,
      30.220959,
      44,
      1.030932,
      NULL,
      NULL,
      1.678099,
      1,
      1.429402,
      0.287694,
      1.438952,
      NULL,
      1,
      0,
      1,
      1.649906,
      0,
      1,
      1.265133,
      1.531200,
      0,
      NULL,
      1.100614,
      NULL,
      0.997171,
      0.126156,
      NULL,
      3.851318,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.275875,
      1,
      0.539281,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.734645,
      0,
      1.045802,
      5,
      0,
      0,
      0.006185,
      1.722653,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.205700,
      0,
      1,
      2,
      NULL,
      NULL,
      1,
      1.538196,
      0,
      NULL,
      0.057956,
      0.720759,
      NULL,
      0,
      1,
      NULL,
      0,
      0.658291,
      NULL,
      NULL,
      1,
      1.631340,
      1.093884,
      NULL,
      0.939990,
      0,
      0.779291,
      0.038627,
      1,
      NULL,
      NULL,
      1.955151,
      0.499472,
      0,
      4,
      1.310131,
      4.365736,
      0,
      NULL,
      6,
      0.929130,
      5.071894,
      0,
      3.215292,
      3,
      1,
      1.157906,
      1,
      1.101740,
      NULL,
      NULL,
      5,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.053405,
      NULL,
      0,
      0,
      1.145202,
      1,
      0,
      0.555306,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0.967845,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      1.001733,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      5,
      1.121392,
      0.024457,
      0,
      1.652201,
      NULL,
      NULL,
      NULL,
      1.725252,
      0.788723,
      0.804578,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.507100,
      3.535873,
      0,
      NULL,
      3.569927,
      0.384751,
      2.756993,
      0.787904,
      1.171462,
      0,
      1.375032,
      NULL,
      NULL,
      0.640488,
      1,
      1.976032,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      '24332',
      NULL,
      '',
      1.632533,
      '',
      NULL,
      '',
      0,
      NULL,
      NULL,
      NULL,
      5.078590,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


