set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9101607';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1999-10-04 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '442',
      '13133023',
      52,
      26.691617,
      '4104311',
      NULL,
      1,
      NULL,
      0,
      '203343',
      0.748856,
      NULL,
      NULL,
      29,
      0,
      NULL,
      1,
      0,
      0,
      0,
      0,
      3.863944,
      0,
      1.896761,
      0,
      0.355410,
      1,
      1,
      0,
      1,
      0.991733,
      1,
      0.230625,
      0.864536,
      1,
      NULL,
      0,
      0.456521,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.613404,
      0,
      1.612986,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.466244,
      0.939900,
      0.925575,
      1,
      0.347642,
      1.871397,
      NULL,
      0.668832,
      0.993477,
      1.931863,
      0,
      1.965819,
      NULL,
      1.359327,
      1.310609,
      1.370511,
      0.255194,
      1,
      1.641778,
      NULL,
      NULL,
      2,
      0.230489,
      1,
      0.053772,
      1,
      3.431668,
      1,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      4.402885,
      1,
      4.563306,
      NULL,
      5.012769,
      NULL,
      5.570806,
      5,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.498931,
      NULL,
      NULL,
      2,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0,
      1,
      1,
      1.943519,
      0.599781,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.706262,
      NULL,
      NULL,
      NULL,
      NULL,
      0.363732,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.611870,
      2,
      0.328629,
      NULL,
      NULL,
      NULL,
      3.139466,
      0.418095,
      0.496663,
      NULL,
      NULL,
      1,
      0.486900,
      NULL,
      NULL,
      NULL,
      0,
      1.900059,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.162467,
      0.981133,
      0,
      NULL,
      0.214980,
      1.533517,
      NULL,
      0.565934,
      1,
      2,
      0,
      NULL,
      1,
      1.032982,
      1,
      1.718178,
      0.648405,
      0,
      1.830144,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      '12003',
      '',
      '',
      0.077293,
      '',
      NULL,
      '',
      1.805428,
      NULL,
      '',
      '',
      0.097913,
      2.539234,
      2,
      1.039240,
      0.213203,
      NULL,
      1.077247,
      2,
      1.047715);
commit;
end;
/


