set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9101607';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-2-27 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '043',
      '30433231',
      14.577256,
      22,
      '1214033',
      133.044608,
      4,
      2,
      NULL,
      '112120',
      NULL,
      ' 2-22-1975',
      19,
      NULL,
      NULL,
      NULL,
      0.887936,
      1,
      0.684709,
      0.305292,
      0.481977,
      NULL,
      1.537189,
      0,
      3.616966,
      1,
      3.212648,
      1,
      3,
      NULL,
      NULL,
      0.194473,
      0.887815,
      0,
      NULL,
      NULL,
      4,
      1,
      NULL,
      1,
      3,
      0.116301,
      1,
      1.601615,
      NULL,
      NULL,
      1.658729,
      NULL,
      NULL,
      1.452963,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.409679,
      1,
      2.460977,
      3,
      NULL,
      0,
      NULL,
      0,
      NULL,
      NULL,
      1.552725,
      NULL,
      NULL,
      0.647021,
      1,
      NULL,
      5,
      NULL,
      1.369539,
      0,
      1,
      0.177272,
      1,
      1.431289,
      NULL,
      1,
      NULL,
      0,
      0.081897,
      1.899855,
      0.578288,
      0,
      NULL,
      1,
      1,
      1.280853,
      1,
      0,
      NULL,
      0,
      1.208981,
      NULL,
      1.864691,
      5.272489,
      2.760401,
      1.789556,
      NULL,
      NULL,
      NULL,
      0,
      5.026399,
      0,
      7,
      4,
      2,
      5,
      1,
      NULL,
      3,
      0.660156,
      3.585234,
      0,
      NULL,
      NULL,
      6,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.387743,
      0.610558,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      0.544195,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      3,
      1,
      NULL,
      NULL,
      NULL,
      4,
      0,
      5.442043,
      5,
      NULL,
      2,
      0.557691,
      NULL,
      NULL,
      NULL,
      0.052125,
      1,
      1.218922,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.332283,
      NULL,
      2,
      0,
      1.923767,
      0.288656,
      1,
      0.762589,
      1.008897,
      1,
      1.761172,
      1.673355,
      0,
      1.621838,
      0.883301,
      1.545890,
      0,
      1.390178,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.828123,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      '42302',
      '',
      '',
      1.387202,
      '',
      '',
      '',
      1.528348,
      '',
      '',
      '',
      NULL,
      2.446002,
      3.362068,
      1,
      NULL,
      2.482566,
      3,
      NULL,
      3.217062);
commit;
end;
/


