set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9101607';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2002-9-11 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '24203411',
      0.968511,
      60.341051,
      '0223144',
      23,
      NULL,
      0.838277,
      2,
      '210430',
      1.166278,
      NULL,
      NULL,
      33,
      NULL,
      NULL,
      NULL,
      0.130904,
      3.398282,
      0,
      0,
      2.557038,
      1,
      NULL,
      NULL,
      1.924063,
      1.723151,
      0,
      0,
      NULL,
      3,
      1,
      5.060702,
      NULL,
      NULL,
      1.911271,
      3,
      0,
      7.135602,
      0,
      0.716293,
      1,
      0.070277,
      0.075079,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.113878,
      1,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.165369,
      5,
      NULL,
      1,
      0,
      1,
      0,
      0.274557,
      NULL,
      NULL,
      0.113696,
      NULL,
      NULL,
      NULL,
      5,
      1.124707,
      1,
      4,
      1,
      NULL,
      0,
      1.528850,
      0,
      0.002420,
      NULL,
      0.904519,
      NULL,
      NULL,
      0.256952,
      NULL,
      1.900202,
      NULL,
      NULL,
      0,
      1,
      0,
      1.490128,
      1,
      0.591607,
      0.644739,
      1,
      5.157276,
      1.423466,
      1.272502,
      1.572358,
      0.306075,
      1,
      5,
      0,
      NULL,
      NULL,
      5.112842,
      6,
      5,
      5.914432,
      0.094336,
      5,
      0.241579,
      2,
      1,
      NULL,
      2,
      0,
      NULL,
      0.193018,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.683877,
      1,
      0,
      1,
      0.225505,
      NULL,
      0.444523,
      0.785009,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.243194,
      NULL,
      3,
      2,
      3.597616,
      0.686697,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.513843,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      4,
      5.435056,
      2,
      0,
      1,
      NULL,
      NULL,
      NULL,
      0,
      5,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      2,
      NULL,
      3,
      NULL,
      0,
      1.491026,
      2,
      NULL,
      NULL,
      1,
      1,
      NULL,
      0.112662,
      1,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.349116,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      '11034',
      NULL,
      '',
      1.142082,
      '',
      '',
      '',
      NULL,
      NULL,
      '',
      '',
      5,
      4.771245,
      1,
      NULL,
      0.173986,
      0.731325,
      1.722043,
      0,
      2);
commit;
end;
/


