set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9101607';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2003-9-24 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0324',
      '11123133',
      81,
      54,
      '2300123',
      34,
      1,
      2,
      3,
      '110001',
      4,
      NULL,
      0.225533,
      5.899399,
      1.612724,
      NULL,
      NULL,
      0,
      2,
      NULL,
      1,
      1.759568,
      0,
      1.338797,
      NULL,
      1.040371,
      NULL,
      1.458463,
      2.547102,
      NULL,
      4.405194,
      NULL,
      NULL,
      0.249323,
      2.782336,
      1.600253,
      0.103494,
      NULL,
      NULL,
      0,
      4,
      3,
      2.439502,
      NULL,
      NULL,
      NULL,
      0.462423,
      NULL,
      NULL,
      NULL,
      1.617829,
      1.654307,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2,
      2.824603,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.861251,
      2.258284,
      2.032645,
      1.132322,
      1.811042,
      0.624676,
      1.063623,
      NULL,
      0,
      NULL,
      1.090060,
      2,
      0.920970,
      0,
      1,
      1,
      0.855334,
      NULL,
      1.776197,
      1,
      0,
      1.475715,
      0,
      1,
      NULL,
      1,
      2.548564,
      1,
      NULL,
      7,
      3,
      3.778094,
      1.463143,
      0,
      7,
      NULL,
      0,
      4.341133,
      0,
      0.702002,
      NULL,
      5,
      NULL,
      NULL,
      1.529641,
      3.479843,
      0.519435,
      0,
      0,
      3,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.640660,
      0,
      1,
      1,
      NULL,
      1.401410,
      0.520370,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.991115,
      NULL,
      1,
      0.806723,
      1,
      1.602289,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.052564,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.873701,
      NULL,
      3,
      5,
      1,
      1,
      NULL,
      NULL,
      NULL,
      0,
      4.287506,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.934509,
      3,
      3.186682,
      0,
      1.320444,
      3,
      0.086181,
      2.515758,
      NULL,
      3,
      1.181603,
      0,
      1.458531,
      1.278336,
      1.842424,
      0.485442,
      0,
      0.001223,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.185138,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3.284547,
      NULL,
      '',
      '',
      NULL,
      '',
      NULL,
      '',
      2.653181,
      '4100',
      '',
      NULL,
      2,
      1,
      NULL,
      1,
      2.177087,
      1.780024,
      1.956267,
      NULL,
      NULL);
commit;
end;
/


