set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9101607';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2004-4-05 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4012',
      '13404243',
      73,
      66,
      '1424342',
      236.118765,
      1,
      3,
      2,
      '243243',
      NULL,
      ' 5-27-1993',
      38,
      NULL,
      0.488202,
      NULL,
      1.036299,
      0.400170,
      0,
      1.290611,
      0,
      0,
      0.219730,
      1,
      2.429832,
      1.254080,
      NULL,
      0,
      4,
      0.642173,
      2,
      1,
      4,
      1.372266,
      0.466406,
      0.837696,
      3,
      2.326053,
      6.216249,
      0,
      2.069595,
      3.396174,
      2.820888,
      1.080810,
      NULL,
      NULL,
      1.415768,
      NULL,
      NULL,
      0,
      NULL,
      1.242429,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1.777413,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1,
      0,
      0.359230,
      1,
      0.397755,
      1,
      1,
      0.534254,
      5,
      1.994297,
      1,
      2.270439,
      0.825487,
      NULL,
      1.740737,
      0.566277,
      0,
      NULL,
      1,
      0.865547,
      1,
      1,
      1.319577,
      1,
      1.117920,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3.661924,
      1,
      5,
      0,
      NULL,
      5.250325,
      5.982488,
      5,
      NULL,
      9.668636,
      NULL,
      2,
      5,
      4,
      1.145986,
      5.028538,
      NULL,
      0,
      1,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.202409,
      3.396735,
      1,
      0,
      1.047263,
      0.848422,
      1,
      0.100957,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.281240,
      NULL,
      6,
      1.912824,
      2.545288,
      1.975221,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1.364701,
      0,
      NULL,
      NULL,
      NULL,
      0,
      0.939714,
      NULL,
      NULL,
      1,
      1,
      0,
      NULL,
      NULL,
      NULL,
      0.065796,
      2,
      1.899304,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2.638888,
      3.998527,
      1.150398,
      NULL,
      0,
      0,
      2.995167,
      0.195728,
      2,
      2,
      NULL,
      0,
      0,
      1.421460,
      1.478109,
      1.011686,
      0.294591,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.309257,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      '',
      '',
      0.650911,
      '',
      '',
      NULL,
      3,
      '1233',
      NULL,
      '',
      4.717568,
      1,
      1.617477,
      5,
      3,
      0,
      2,
      1,
      2.264623);
commit;
end;
/


