set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9101607';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2004-9-07 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4144',
      '1',
      NULL,
      32.650358,
      '0203313',
      37,
      4,
      3.774132,
      1,
      NULL,
      4.730546,
      NULL,
      5.559636,
      42,
      1.508832,
      NULL,
      0,
      0.165388,
      1,
      1.061654,
      NULL,
      3.903469,
      NULL,
      1.449565,
      3,
      NULL,
      2,
      0,
      3.830834,
      1.618292,
      2.722660,
      1,
      1.696729,
      0.329199,
      NULL,
      0,
      3,
      2.813841,
      NULL,
      0,
      4.357202,
      2.597026,
      3,
      0,
      NULL,
      NULL,
      1.284318,
      NULL,
      NULL,
      0,
      1.569600,
      0.141303,
      1.198230,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.002467,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      4,
      0.153695,
      1.987208,
      0,
      1,
      NULL,
      1.298649,
      1.099781,
      0,
      1.327184,
      NULL,
      0.888431,
      1,
      1,
      1.569213,
      0.963928,
      NULL,
      1.399828,
      NULL,
      1,
      1.390633,
      2.263574,
      0.439494,
      0,
      1,
      6,
      2.923929,
      NULL,
      5.344138,
      7,
      1,
      3.088337,
      1.581923,
      2,
      5.861755,
      5,
      4.917483,
      NULL,
      7.579067,
      1.927990,
      4,
      1,
      1.983881,
      0.806736,
      4.147838,
      0.093124,
      NULL,
      NULL,
      0.553074,
      0.988793,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.164942,
      1.929377,
      0,
      0,
      0.536139,
      0.385219,
      1.404711,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.486872,
      NULL,
      3,
      1,
      2.237572,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2,
      1.402291,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3,
      0.922702,
      5.023677,
      0,
      1.677386,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      3,
      0,
      0.158081,
      NULL,
      1,
      1.039366,
      1,
      0,
      1,
      0,
      1,
      NULL,
      1.279250,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.028663,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.112876,
      '02302',
      '',
      '',
      1.633124,
      '',
      '',
      '',
      NULL,
      '4004',
      NULL,
      '',
      1.927293,
      0,
      2,
      5.847955,
      0,
      NULL,
      NULL,
      0,
      0.870934);
commit;
end;
/


