set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9101607';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2005-3-29 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0340',
      '30111203',
      50.885843,
      71.975184,
      '2232042',
      114.032864,
      3,
      0,
      3,
      '440401',
      3.798535,
      ' 7-10-1981',
      37,
      57,
      NULL,
      NULL,
      1.119029,
      NULL,
      0.787425,
      0.076150,
      1.186651,
      0,
      1.580022,
      1,
      1,
      NULL,
      0.671231,
      0.189991,
      1,
      1.313084,
      5.216999,
      0.710101,
      7,
      1,
      NULL,
      NULL,
      7.116966,
      7.267438,
      2,
      0,
      2,
      1.261921,
      3.238726,
      NULL,
      NULL,
      NULL,
      0.306250,
      NULL,
      NULL,
      1.504440,
      1.985999,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      3.542574,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2,
      1.832625,
      2.908872,
      2.230112,
      NULL,
      0.025365,
      0.598600,
      1.307068,
      0.646867,
      1,
      1,
      0,
      0,
      1,
      0,
      0.712141,
      NULL,
      1.764657,
      NULL,
      1.955758,
      0,
      2,
      NULL,
      1.996310,
      3.950199,
      0.618840,
      0,
      5,
      0,
      5.541280,
      7,
      5.717852,
      3.140452,
      NULL,
      1,
      7.928921,
      NULL,
      0.941313,
      1,
      NULL,
      8,
      5,
      3.942008,
      2.687206,
      NULL,
      0.201633,
      2,
      1,
      NULL,
      NULL,
      5,
      1.985988,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2,
      NULL,
      1,
      0,
      0.096637,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.076939,
      NULL,
      0.136641,
      NULL,
      3,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.659369,
      3.603534,
      0.358751,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      1.453681,
      0,
      1,
      0.288015,
      NULL,
      NULL,
      NULL,
      NULL,
      8,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.978337,
      NULL,
      0,
      0.159865,
      NULL,
      NULL,
      2.456644,
      1.734602,
      1,
      0.674615,
      1.069100,
      1,
      1.930435,
      0.894661,
      0,
      0,
      0.692530,
      NULL,
      1.126545,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      '21012',
      NULL,
      NULL,
      0.424627,
      '',
      NULL,
      '',
      3,
      NULL,
      '',
      '',
      0.452370,
      2.364462,
      NULL,
      4,
      NULL,
      1,
      2.559149,
      3,
      NULL);
commit;
end;
/


