set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9976944';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2005-1-20 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3333',
      '32010412',
      NULL,
      31,
      NULL,
      NULL,
      5,
      1,
      NULL,
      '002004',
      NULL,
      ' 1- 5-1986',
      48.479119,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0,
      NULL,
      2.058439,
      1,
      NULL,
      0.649201,
      0.423863,
      1,
      NULL,
      NULL,
      1,
      1.711784,
      0.632519,
      NULL,
      1,
      0.577979,
      1,
      1.852236,
      1.314814,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.343105,
      0,
      0.760717,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.010074,
      NULL,
      4.571276,
      0.474268,
      3,
      1,
      1.504867,
      1.075307,
      0.187687,
      NULL,
      0,
      NULL,
      NULL,
      1.026294,
      0,
      1.633505,
      1.461678,
      NULL,
      1,
      NULL,
      0,
      NULL,
      NULL,
      1.501019,
      0.009968,
      0,
      3.459278,
      0.458922,
      5,
      4.280828,
      7.688068,
      5,
      1,
      0.687689,
      1,
      0,
      0,
      3,
      1.109171,
      0.949265,
      NULL,
      1,
      5,
      NULL,
      7,
      NULL,
      5,
      1,
      0.141938,
      NULL,
      NULL,
      4,
      1.016300,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.832885,
      1,
      1,
      0.310165,
      1,
      1,
      1.052004,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.713970,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3.479134,
      1,
      NULL,
      NULL,
      NULL,
      1.563575,
      NULL,
      4.383399,
      7,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0.494015,
      3.637062,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.347098,
      1.393227,
      NULL,
      1,
      NULL,
      1,
      0,
      0.459975,
      3,
      0,
      NULL,
      0.982227,
      1,
      1,
      NULL,
      1.409814,
      0.935848,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      '24242',
      '02033',
      NULL,
      0.066065,
      '22142',
      '',
      NULL,
      1.508793,
      '11412',
      NULL,
      NULL,
      NULL,
      0,
      1,
      1,
      1,
      NULL,
      2,
      1.314988,
      5.886158);
commit;
end;
/


