set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9727941';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-7-23 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '44031434',
      NULL,
      57,
      '4301034',
      55,
      5,
      2,
      3,
      '213023',
      0,
      ' 5- 5-1992',
      NULL,
      93.557262,
      0,
      NULL,
      0.682456,
      3,
      0,
      1.743898,
      3.865179,
      1.531669,
      3.191113,
      NULL,
      1.005207,
      NULL,
      2,
      NULL,
      1.092220,
      NULL,
      1,
      0,
      NULL,
      0.728174,
      0,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      1.050556,
      NULL,
      NULL,
      NULL,
      1.619941,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.891121,
      0,
      1.142325,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.340848,
      0.062670,
      1.610395,
      1,
      1.123436,
      NULL,
      1.757616,
      1.292367,
      1.722668,
      1.738305,
      1.414171,
      0.484099,
      NULL,
      1,
      NULL,
      0.373541,
      NULL,
      0.906838,
      0.965367,
      NULL,
      3.399092,
      1.751069,
      1,
      NULL,
      1.920973,
      0.744276,
      4,
      1.156193,
      2.883993,
      1,
      0.101033,
      3.348488,
      NULL,
      4,
      3.057136,
      1,
      NULL,
      2.292336,
      8.422736,
      1.978686,
      NULL,
      6.813873,
      5.863981,
      NULL,
      2,
      4,
      4,
      3,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.141756,
      1,
      1,
      0,
      NULL,
      NULL,
      1,
      0.565847,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.106376,
      NULL,
      7,
      2.322862,
      3,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.313774,
      0.276590,
      1,
      NULL,
      NULL,
      NULL,
      0,
      2,
      NULL,
      4,
      0.817570,
      2,
      0,
      NULL,
      NULL,
      NULL,
      0,
      2,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.803011,
      NULL,
      0.811711,
      1,
      1.843314,
      1,
      3.345445,
      2,
      1,
      3.536631,
      2,
      1,
      2.483012,
      NULL,
      1,
      1,
      0.167157,
      0.877509,
      NULL,
      3.224996,
      NULL,
      0,
      NULL,
      1.225729,
      0,
      3.216918,
      NULL,
      0,
      1,
      0,
      NULL,
      NULL,
      0.150107,
      0,
      0,
      1,
      0,
      NULL,
      0.933243,
      0.696750,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.318177,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.971276,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.540429,
      NULL,
      1.817692,
      NULL,
      NULL,
      2,
      3.109448,
      '24033',
      '',
      '',
      1.931992,
      '',
      '',
      '',
      0.231338,
      NULL,
      '',
      '',
      NULL,
      3,
      1,
      3,
      3,
      NULL,
      2,
      1.412621,
      0);
commit;
end;
/


