set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9727941';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2002-8-21 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '032',
      NULL,
      79,
      NULL,
      NULL,
      45.744861,
      6,
      NULL,
      2,
      '201122',
      NULL,
      ' 5- 9-2000',
      70,
      60.521001,
      NULL,
      NULL,
      1,
      0.650530,
      0.738624,
      1,
      0,
      1.394084,
      3.713763,
      2,
      NULL,
      0.359897,
      0,
      0.349259,
      0,
      NULL,
      NULL,
      0,
      NULL,
      0,
      0.611602,
      0.290374,
      1,
      1.333484,
      0.305978,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.066284,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.427012,
      1.035907,
      1.733164,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.112786,
      1.185847,
      0,
      1,
      1.654604,
      0.062961,
      0,
      0,
      0,
      1,
      0.514793,
      1,
      NULL,
      0.078604,
      1.902540,
      0,
      NULL,
      NULL,
      NULL,
      0,
      4,
      2,
      0,
      1,
      0,
      1.073054,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      3,
      5.292615,
      0,
      2,
      5,
      7.655855,
      3.577999,
      0,
      5.886910,
      7.107608,
      5,
      4,
      0.124823,
      NULL,
      3.425986,
      1,
      NULL,
      NULL,
      8.423942,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.925934,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      5,
      1,
      NULL,
      NULL,
      0.005146,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.985501,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.719919,
      0.135129,
      1.999667,
      0,
      NULL,
      2.789387,
      2.731480,
      1,
      NULL,
      1.774146,
      1.917147,
      NULL,
      1.649414,
      0,
      0.004348,
      0,
      1.170552,
      1,
      NULL,
      0.541058,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0.412002,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.764885,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.920790,
      NULL,
      NULL,
      NULL,
      NULL,
      1.220793,
      NULL,
      NULL,
      NULL,
      NULL,
      2.478599,
      1,
      NULL,
      NULL,
      0.585909,
      1.908616,
      1.584112,
      NULL,
      NULL,
      '11421',
      '',
      '',
      1.730387,
      '',
      NULL,
      '',
      1,
      '',
      '',
      '',
      5,
      2,
      2,
      3.449504,
      NULL,
      3,
      2.667646,
      3,
      0.995033);
commit;
end;
/


