set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9727941';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2003-1-07 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '233',
      '42322203',
      56.199574,
      10.185074,
      '2441214',
      66.581831,
      2,
      2,
      3,
      NULL,
      4,
      '11- 5-1977',
      6.412431,
      126,
      1.617229,
      NULL,
      0.753419,
      0.497021,
      1,
      0.050601,
      1,
      2.311301,
      0,
      3.564839,
      1,
      0.939718,
      NULL,
      1.101947,
      NULL,
      0.060313,
      1.215087,
      0.924390,
      0,
      0.440790,
      0.943305,
      0.487932,
      1,
      0.486068,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0.658654,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1,
      0.496753,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.675508,
      0,
      1,
      0,
      0.826671,
      0,
      1,
      1,
      1,
      1,
      0,
      1.032828,
      1,
      0,
      1,
      1,
      1.339020,
      NULL,
      NULL,
      1,
      0.617135,
      0,
      0.815072,
      3,
      0,
      0.941010,
      NULL,
      NULL,
      5.344764,
      1.472692,
      0,
      0.771831,
      3,
      0.650072,
      1,
      NULL,
      NULL,
      1.134194,
      NULL,
      4.969272,
      9,
      11,
      1.013058,
      NULL,
      1.797187,
      0,
      1.948527,
      0.746344,
      NULL,
      NULL,
      4.324958,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0,
      0,
      0.398125,
      0.314817,
      1.439225,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.980831,
      NULL,
      2.609981,
      2.415288,
      0.530624,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1.106531,
      NULL,
      NULL,
      NULL,
      0.174625,
      1.103825,
      2,
      8,
      1.057215,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.168500,
      4,
      1.695594,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.458373,
      1,
      0,
      NULL,
      1,
      0,
      2.183838,
      2,
      NULL,
      NULL,
      2.056493,
      NULL,
      0,
      NULL,
      0.705269,
      0.580735,
      1,
      0,
      1.172934,
      0.112876,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.632774,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.996995,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1.169180,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.545929,
      NULL,
      0.595255,
      1.757701,
      NULL,
      2,
      3,
      '00103',
      '',
      '',
      0.632463,
      '',
      '',
      '',
      NULL,
      '',
      '',
      '',
      4.945824,
      3.041736,
      0.268374,
      3.950924,
      0.228441,
      0.602259,
      3.280841,
      3.541916,
      NULL);
commit;
end;
/


