set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9727941';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2003-7-14 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4000',
      '14410043',
      9,
      29.248733,
      NULL,
      75,
      1,
      0.148350,
      2,
      '130432',
      NULL,
      '10- 9-1986',
      171,
      70,
      0.933399,
      NULL,
      2.933028,
      NULL,
      1,
      1.188924,
      0,
      NULL,
      0.022542,
      1.239504,
      NULL,
      0,
      0,
      1,
      1.579334,
      NULL,
      0.867435,
      NULL,
      0,
      0.308220,
      1,
      NULL,
      1,
      1.876305,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.137164,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.539416,
      1.563166,
      1.940255,
      1,
      0.541062,
      0.899838,
      1,
      0.056837,
      1.586110,
      1.242064,
      0,
      NULL,
      0.371569,
      0.480150,
      1.984025,
      0.289644,
      0,
      1,
      NULL,
      1,
      4.326153,
      0,
      NULL,
      NULL,
      0,
      2,
      NULL,
      6.358369,
      0,
      0,
      3,
      NULL,
      NULL,
      NULL,
      1.280554,
      3.323538,
      0.054796,
      1.259025,
      0,
      5.420046,
      5,
      3,
      NULL,
      0.863227,
      1,
      1.700562,
      0.086495,
      0.210415,
      NULL,
      NULL,
      NULL,
      0.805394,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.305728,
      NULL,
      NULL,
      0,
      NULL,
      1.147368,
      0.818790,
      0.785056,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.354440,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1.787207,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.692683,
      0.589601,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1.753281,
      1,
      2.162926,
      3.106765,
      3.616637,
      1,
      3,
      NULL,
      0,
      0.547264,
      NULL,
      NULL,
      1.437848,
      1,
      1,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.140263,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1.412939,
      NULL,
      NULL,
      NULL,
      NULL,
      1.504713,
      1.482392,
      0,
      NULL,
      1.813137,
      1,
      0.017470,
      1,
      0.662107,
      '23204',
      '',
      '',
      0,
      NULL,
      '',
      '',
      0.659775,
      '',
      NULL,
      '',
      1,
      3,
      1.803686,
      0,
      0.336096,
      NULL,
      0,
      0,
      2);
commit;
end;
/


