set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9727941';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2004-7-26 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0243',
      '4',
      NULL,
      88.520499,
      '3212334',
      103.608078,
      4,
      2.513355,
      1,
      NULL,
      3.518495,
      ' 1-17-1974',
      NULL,
      NULL,
      1.595872,
      NULL,
      1.567630,
      NULL,
      NULL,
      0,
      1,
      1.132041,
      1.073204,
      0,
      0,
      1.238367,
      0.398232,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0,
      1,
      NULL,
      1,
      NULL,
      1,
      1.427938,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      1,
      NULL,
      2.473272,
      0,
      1.393917,
      1,
      1.643671,
      1.473960,
      1,
      0,
      1.534328,
      0,
      NULL,
      2.124752,
      0.818675,
      1,
      1,
      0.760292,
      1.569252,
      0.110278,
      0,
      1,
      NULL,
      1,
      1,
      1,
      NULL,
      NULL,
      0.105406,
      NULL,
      NULL,
      1.201892,
      0,
      1.161812,
      NULL,
      1,
      0.003757,
      1.108302,
      0,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      1.149207,
      1,
      1,
      NULL,
      NULL,
      NULL,
      1,
      7.747755,
      0.410525,
      NULL,
      NULL,
      0.431490,
      1,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      6.807197,
      6.364529,
      1,
      0.430542,
      1.173376,
      1.395371,
      NULL,
      2,
      NULL,
      NULL,
      6.168169,
      2.090373,
      0,
      0,
      1.413706,
      0.673216,
      NULL,
      NULL,
      9.695422,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.665384,
      NULL,
      1,
      0.220834,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.714371,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0.583960,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.822134,
      7.796811,
      4,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.318034,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.124801,
      0.433891,
      2,
      0.607247,
      3,
      NULL,
      NULL,
      0.259897,
      2.285838,
      NULL,
      0.970077,
      0.294048,
      0.435410,
      0.028969,
      NULL,
      0.681925,
      NULL,
      1.466909,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.362498,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.952225,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.326239,
      1,
      1.821981,
      NULL,
      1.629794,
      0.336293,
      1,
      2,
      NULL,
      '04331',
      NULL,
      NULL,
      0.543969,
      NULL,
      '',
      '',
      1,
      '',
      '',
      '',
      3,
      0.705385,
      1.382861,
      NULL,
      1.282880,
      3,
      3,
      1,
      NULL);
commit;
end;
/


