set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9727941';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2005-2-15 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3144',
      '30013203',
      77.590092,
      59.145553,
      '2104223',
      NULL,
      NULL,
      3.051673,
      NULL,
      '033243',
      NULL,
      '11-10-1982',
      NULL,
      17,
      NULL,
      NULL,
      0,
      NULL,
      0,
      0.607990,
      0.579413,
      1,
      3,
      0,
      1,
      NULL,
      0.796386,
      NULL,
      0.288459,
      0.941231,
      NULL,
      1.825189,
      1,
      1,
      0.978846,
      1.198048,
      1.202465,
      1.830039,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.975230,
      1.076852,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.000014,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.873547,
      1,
      1.171070,
      0.884896,
      1.768467,
      0,
      NULL,
      0,
      1,
      1.751723,
      1.750677,
      1,
      1,
      0.756861,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      4,
      0.037834,
      1.522266,
      NULL,
      0.651155,
      7.914419,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      NULL,
      1.762550,
      3.855559,
      0.054863,
      0,
      1.777239,
      0.731057,
      9.035239,
      7,
      2,
      NULL,
      1.101195,
      0.724807,
      0.954327,
      1.838168,
      NULL,
      NULL,
      7.283910,
      1.512382,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.009078,
      1,
      1,
      0,
      0,
      0,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7,
      2,
      NULL,
      0.530180,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6.527399,
      0.140120,
      0,
      NULL,
      NULL,
      NULL,
      0.005983,
      1,
      7,
      NULL,
      NULL,
      2,
      0.359270,
      NULL,
      NULL,
      NULL,
      1,
      3,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.289826,
      NULL,
      NULL,
      3,
      0.858839,
      NULL,
      0,
      0,
      NULL,
      NULL,
      0.374692,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0.758482,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.893281,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.605273,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.624830,
      1,
      1.855209,
      NULL,
      0,
      0.645145,
      1,
      1,
      3.253178,
      '40344',
      '',
      '',
      0.432459,
      '',
      '',
      '',
      0.856346,
      '',
      '',
      NULL,
      1,
      0,
      0,
      3,
      3,
      NULL,
      2.795028,
      0.385012,
      3);
commit;
end;
/


