set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9650098';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1997-10-14 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '34',
      20,
      23.657115,
      '3134130',
      11,
      6,
      1,
      3,
      NULL,
      0,
      ' 5-19-2002',
      NULL,
      28.972377,
      NULL,
      NULL,
      0.529218,
      3.941207,
      0.501946,
      1.800993,
      1.919663,
      NULL,
      3,
      1,
      NULL,
      0,
      0.923119,
      0,
      0,
      1.310228,
      0,
      1.500863,
      NULL,
      1.576756,
      1.731838,
      1,
      1.371307,
      1.965720,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.001713,
      0,
      0,
      2.213832,
      1,
      NULL,
      1,
      NULL,
      1.419640,
      0,
      NULL,
      3,
      1.121190,
      0,
      1,
      2,
      2.628853,
      0.018516,
      NULL,
      0,
      0,
      0,
      NULL,
      2,
      1,
      1.089661,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.315907,
      0,
      3.830227,
      1,
      1.071154,
      1.517813,
      1,
      1.862040,
      1.379357,
      NULL,
      NULL,
      1.298675,
      0,
      1,
      1.134274,
      1.153137,
      0,
      NULL,
      1.628689,
      3,
      1.910628,
      0.107955,
      1,
      1.820035,
      0.647407,
      1,
      5.504908,
      0,
      0,
      1.812785,
      0,
      NULL,
      4,
      0.375285,
      0.763737,
      NULL,
      NULL,
      8,
      0.968047,
      5,
      2,
      7.465435,
      6.178530,
      NULL,
      1,
      2,
      0.140734,
      NULL,
      NULL,
      5.381917,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.210031,
      1,
      NULL,
      1,
      1,
      1.511160,
      0,
      0.826911,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      0.018866,
      2.471121,
      1.197901,
      0,
      NULL,
      NULL,
      1,
      0,
      NULL,
      6.567049,
      0,
      0.577167,
      NULL,
      NULL,
      NULL,
      0.491764,
      1.242288,
      NULL,
      3,
      7,
      2,
      3,
      0.690997,
      NULL,
      NULL,
      1,
      9,
      1,
      NULL,
      4,
      1,
      1.012153,
      0,
      1.067413,
      1,
      0.377601,
      0,
      0.340042,
      1.383657,
      1,
      1,
      NULL,
      0,
      0,
      0.499652,
      0.014052,
      1.993690,
      1.107975,
      0.168126,
      1,
      0.527482,
      1,
      0.171310,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.764518,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.374518,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.923636,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1,
      0.891456,
      NULL,
      0,
      1.531523,
      NULL,
      1,
      4,
      '04024',
      '32214',
      NULL,
      NULL,
      NULL,
      '',
      '',
      1,
      '',
      NULL,
      '',
      5.205783,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


