set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8814999';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1993-8-28 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0',
      '1',
      NULL,
      NULL,
      '3222312',
      64,
      5,
      2.380697,
      1,
      '000403',
      0.698384,
      '10- 9-1983',
      10.183188,
      NULL,
      0.734480,
      NULL,
      NULL,
      2.990166,
      1,
      0.375214,
      1.820293,
      2,
      1.773432,
      0,
      1,
      NULL,
      NULL,
      1,
      0.660127,
      0.570841,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.734346,
      6,
      1,
      5,
      0.404553,
      NULL,
      NULL,
      NULL,
      NULL,
      1.834044,
      NULL,
      NULL,
      0.128394,
      1.901065,
      1.279596,
      1.582008,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.751046,
      NULL,
      1.367736,
      0.261943,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      5.304675,
      1,
      1,
      NULL,
      1.255935,
      0,
      0,
      1,
      0,
      NULL,
      0.774025,
      0.153168,
      2.378947,
      NULL,
      1,
      NULL,
      1,
      0,
      NULL,
      1.063250,
      NULL,
      0,
      NULL,
      0,
      0.154700,
      0,
      1.751740,
      NULL,
      1.562949,
      NULL,
      3,
      0,
      NULL,
      3,
      NULL,
      NULL,
      4.427355,
      3.983358,
      NULL,
      5.011755,
      6,
      5,
      2,
      1.350289,
      4,
      3,
      2.304765,
      3.487410,
      1,
      0,
      3,
      0.667610,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.246106,
      0,
      0,
      0,
      1.570118,
      1,
      1.801660,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.924340,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6,
      0,
      1.238742,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.669055,
      0,
      NULL,
      0.331630,
      NULL,
      NULL,
      NULL,
      NULL,
      0.109170,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.322207,
      1.656534,
      1,
      1.641430,
      2.388342,
      NULL,
      1.333329,
      3.082266,
      0.957923,
      3,
      0,
      0,
      NULL,
      NULL,
      0.220430,
      0,
      NULL,
      0,
      NULL,
      0.776535,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.858382,
      '00330',
      '',
      '',
      NULL,
      NULL,
      '',
      NULL,
      NULL,
      '',
      '',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


