set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8814999';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1998-11-17 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '312',
      '03',
      38,
      3.618049,
      NULL,
      42.274145,
      6,
      0,
      3,
      '330143',
      NULL,
      ' 2-14-1982',
      2.959934,
      33,
      NULL,
      NULL,
      NULL,
      0.057760,
      0.133601,
      0.320740,
      0.918471,
      0,
      NULL,
      NULL,
      1.209583,
      1,
      NULL,
      0,
      1,
      NULL,
      1,
      1,
      NULL,
      1,
      NULL,
      0,
      0,
      0.188575,
      0.800924,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      1.126978,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.612462,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.485143,
      5,
      1,
      0.278238,
      1.873429,
      0.960942,
      1,
      1.244959,
      1.328439,
      1.019144,
      1.645323,
      1.531867,
      1.211172,
      0,
      1,
      NULL,
      0.772709,
      0.299595,
      NULL,
      NULL,
      0,
      0,
      1.562876,
      NULL,
      0.490540,
      0.614895,
      1.272164,
      3.060126,
      NULL,
      1.894755,
      1,
      0,
      1.169933,
      NULL,
      1.240422,
      0,
      4.679363,
      0,
      3,
      0,
      6,
      0,
      2.652087,
      1.498407,
      1.841869,
      NULL,
      2.066586,
      NULL,
      NULL,
      NULL,
      8.533956,
      1.335631,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.382839,
      NULL,
      2,
      1,
      NULL,
      0.859395,
      0.133012,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      0.085474,
      NULL,
      0.115279,
      NULL,
      0.848055,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.167624,
      0,
      1.145975,
      1.397442,
      1.511025,
      2,
      1.344697,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0.461286,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.174181,
      1,
      1.577208,
      NULL,
      0.738600,
      0,
      0.927467,
      0,
      1.913126,
      2.259657,
      1,
      NULL,
      1,
      1.146158,
      1.756035,
      1,
      NULL,
      1.382429,
      NULL,
      0.586475,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.886799,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.254666,
      NULL,
      '',
      '',
      1.611771,
      NULL,
      '',
      '',
      1,
      '',
      '',
      NULL,
      4.060598,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


