set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8814999';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2000-6-12 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '331',
      '00340414',
      29.007265,
      61,
      '3312140',
      110.461323,
      NULL,
      NULL,
      NULL,
      '414432',
      1.608816,
      ' 3-23-2002',
      24,
      28.833344,
      0,
      NULL,
      7,
      1,
      NULL,
      0,
      1.489066,
      NULL,
      3,
      1.333079,
      1.042683,
      1,
      NULL,
      0,
      1,
      1.229882,
      1,
      1.169826,
      5.763459,
      0.320450,
      3.108554,
      0,
      0.189727,
      0.459515,
      0.024399,
      1,
      NULL,
      3,
      2.633811,
      0.653599,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      0.043862,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.921201,
      1.046749,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      3.603292,
      0.277077,
      2,
      0.484219,
      NULL,
      1.394348,
      1.035880,
      NULL,
      0,
      1.605710,
      0,
      0,
      0.200355,
      0,
      NULL,
      1,
      0.741162,
      NULL,
      NULL,
      NULL,
      NULL,
      1.097162,
      0,
      0,
      0.844156,
      1.651594,
      4,
      0.526814,
      0,
      NULL,
      1,
      0,
      4,
      0,
      1,
      NULL,
      5.819573,
      6.794773,
      6.526468,
      0,
      2,
      NULL,
      5.936128,
      1.056573,
      NULL,
      0.767195,
      1.771027,
      1,
      1.311197,
      3,
      1.150362,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      0,
      0.693644,
      1.594879,
      1,
      1.463218,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.769020,
      NULL,
      NULL,
      2,
      1.896319,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.405828,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.655699,
      0.519141,
      3,
      5.829446,
      NULL,
      NULL,
      1.942089,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.621710,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.611876,
      3,
      1.419132,
      1.058678,
      0,
      0.564743,
      1,
      0.884349,
      1,
      0,
      0.625371,
      0,
      0.909178,
      1,
      NULL,
      NULL,
      0.007903,
      1,
      0.026867,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0.861849,
      NULL,
      NULL,
      '',
      0,
      '',
      '',
      NULL,
      1.389347,
      '',
      NULL,
      '',
      NULL,
      3.073201,
      3,
      7,
      1,
      2,
      3.201146,
      0.566568,
      3.180133);
commit;
end;
/


