set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8814999';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-1-12 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '423',
      '13441222',
      8,
      2.069665,
      NULL,
      93.838111,
      1,
      1.744691,
      2,
      '110044',
      3,
      ' 4-17-1999',
      55.687925,
      26,
      1,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1,
      1,
      1,
      0.381875,
      NULL,
      1,
      1,
      1,
      0.154091,
      0,
      0.787077,
      1,
      2,
      1,
      0,
      0,
      1.665816,
      0.789306,
      2.305324,
      NULL,
      1.712505,
      1,
      0.024449,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.947845,
      NULL,
      0.651230,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.368450,
      NULL,
      0,
      0,
      0,
      0.431368,
      1.818941,
      0,
      1.565320,
      1.471939,
      0.998474,
      0.349841,
      0.755736,
      1,
      1.781757,
      0,
      0.441775,
      0,
      NULL,
      1.568683,
      0.797468,
      NULL,
      1,
      1,
      NULL,
      0.055747,
      1,
      1,
      0.787091,
      0,
      1,
      1,
      0.393503,
      0.105761,
      0,
      3.871629,
      0.436012,
      0,
      0,
      4,
      3,
      0.295119,
      0.120893,
      NULL,
      1,
      0,
      1,
      0,
      NULL,
      NULL,
      NULL,
      0.149716,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      0,
      1,
      1.642896,
      0.078463,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.679305,
      NULL,
      NULL,
      NULL,
      NULL,
      2.851731,
      NULL,
      3.398829,
      1,
      NULL,
      2,
      3,
      NULL,
      1.901384,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      4.069807,
      7.389991,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.938872,
      0.702658,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      0.007653,
      0,
      NULL,
      NULL,
      2.217414,
      0.325105,
      NULL,
      0,
      NULL,
      1.276271,
      0,
      1,
      0,
      0.929044,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      '21344',
      '',
      '',
      0.361262,
      '',
      '',
      '',
      0.345501,
      '',
      '',
      '',
      4,
      2.121889,
      3,
      2.170047,
      0,
      4.273702,
      1,
      NULL,
      NULL);
commit;
end;
/


