set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8814999';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-6-29 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '302',
      '32424104',
      NULL,
      4,
      '1344043',
      143,
      1,
      NULL,
      NULL,
      '143314',
      2,
      ' 4- 4-2002',
      29,
      65,
      1.667161,
      NULL,
      0.249957,
      NULL,
      NULL,
      1,
      0,
      0,
      2,
      1,
      1.331769,
      1.006246,
      5,
      NULL,
      1,
      0.541503,
      1.374454,
      0.185556,
      NULL,
      NULL,
      0,
      NULL,
      0.331513,
      0,
      3.984747,
      0,
      1.004045,
      NULL,
      1,
      0,
      NULL,
      NULL,
      0.596316,
      NULL,
      NULL,
      0,
      0.617443,
      1.477766,
      0.869642,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.740518,
      1,
      1.648186,
      1.504369,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0,
      0.039245,
      1.820296,
      0.357196,
      1,
      NULL,
      0.918922,
      1,
      0.274456,
      1.067134,
      0,
      1,
      0,
      1,
      0,
      0.101790,
      NULL,
      NULL,
      0,
      0.177469,
      1.536167,
      0.653657,
      1,
      1.621453,
      0,
      0,
      1,
      NULL,
      0.158191,
      1,
      0.784218,
      3.590698,
      1.141427,
      1,
      0.556062,
      1,
      2.281766,
      5.970479,
      0,
      0.031707,
      1,
      NULL,
      NULL,
      1.944526,
      1.048725,
      NULL,
      NULL,
      NULL,
      5.512383,
      0.307965,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.150983,
      0.972016,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      3.220940,
      NULL,
      1.836412,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.704231,
      0,
      NULL,
      NULL,
      NULL,
      0.080394,
      0.478409,
      5.098425,
      NULL,
      1.967237,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.574257,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.975404,
      1.901779,
      2.349912,
      1.458942,
      1,
      0,
      1,
      0.175969,
      NULL,
      3,
      0.407087,
      1.984570,
      1.219747,
      1.489839,
      1,
      1.131871,
      0,
      0.658359,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      '41113',
      '',
      '',
      1,
      '',
      '',
      '',
      1.711754,
      '',
      '',
      NULL,
      1,
      2,
      0.902861,
      5,
      2,
      1.781364,
      2,
      NULL,
      4);
commit;
end;
/


