set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8814999';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2002-1-08 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '403',
      '20030041',
      30,
      NULL,
      '0110030',
      NULL,
      0,
      2.140020,
      1,
      '440101',
      1,
      NULL,
      52,
      35.294155,
      0.517917,
      NULL,
      NULL,
      2.176534,
      1.769272,
      0,
      1.957845,
      1.225734,
      NULL,
      1.313148,
      1,
      0.710731,
      1.902648,
      1.947842,
      0,
      0,
      0,
      NULL,
      0,
      1,
      0,
      1,
      1.135021,
      NULL,
      1,
      1,
      NULL,
      0.051248,
      NULL,
      0,
      NULL,
      NULL,
      1.689768,
      NULL,
      NULL,
      NULL,
      1.372552,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.297650,
      NULL,
      1,
      1.506750,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.498830,
      0,
      1,
      1.742254,
      0.455929,
      0.160377,
      NULL,
      5.252738,
      0,
      1.557213,
      2.794623,
      1,
      NULL,
      0.699761,
      0,
      1,
      NULL,
      NULL,
      0.869922,
      1.659063,
      0.985127,
      1,
      NULL,
      NULL,
      NULL,
      4.813951,
      NULL,
      NULL,
      1,
      5.630670,
      0.988442,
      3.364513,
      NULL,
      1.373221,
      6,
      NULL,
      2,
      4.287710,
      7,
      0.968717,
      1,
      NULL,
      3,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      3.418986,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.214502,
      3.112789,
      1,
      1,
      0.090297,
      0,
      0,
      0.189353,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.329530,
      0,
      0,
      3.441754,
      0.586078,
      1.365395,
      0,
      1.023418,
      1.976178,
      0.893114,
      0,
      2.970008,
      1,
      0,
      NULL,
      NULL,
      0,
      3.284883,
      5.437488,
      1,
      0,
      0,
      0,
      NULL,
      NULL,
      1,
      NULL,
      1.056872,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      3,
      0.977194,
      0.694763,
      1.561828,
      1,
      0.167671,
      0.023566,
      3,
      1.587617,
      NULL,
      NULL,
      0.121013,
      NULL,
      1.174040,
      1.831604,
      1.967249,
      NULL,
      0.668757,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      '03424',
      '',
      '',
      1,
      '',
      NULL,
      NULL,
      0.927683,
      NULL,
      NULL,
      '',
      2.098477,
      3.949023,
      0.498656,
      2.118160,
      1,
      5.236924,
      1,
      3,
      1);
commit;
end;
/


