set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8814999';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2002-6-10 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '003',
      NULL,
      37.384226,
      7.520553,
      '1312420',
      NULL,
      1,
      NULL,
      3,
      '202303',
      0,
      ' 2- 8-1998',
      16,
      29.812657,
      NULL,
      NULL,
      1.244053,
      0,
      1,
      0.221356,
      1,
      1.196602,
      1,
      1,
      1,
      0,
      2.419662,
      0,
      0.439738,
      1.567460,
      1,
      0,
      3,
      0,
      1,
      1,
      0.821070,
      1,
      3.473606,
      0,
      0,
      0.432848,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.743796,
      0.389076,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1.797564,
      0.000251,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0.161391,
      1.850232,
      2,
      NULL,
      NULL,
      0.892423,
      0.425952,
      1.990549,
      NULL,
      NULL,
      1,
      0.944913,
      NULL,
      0,
      1,
      NULL,
      0,
      NULL,
      NULL,
      1.927723,
      0,
      NULL,
      1,
      1,
      0,
      1.660915,
      NULL,
      1,
      NULL,
      1,
      0.664618,
      1.624937,
      3.752708,
      1,
      1.451036,
      2,
      NULL,
      1,
      2.575556,
      4,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      6.766972,
      NULL,
      NULL,
      2,
      1.418482,
      0.699653,
      0.237196,
      3,
      1,
      1,
      1,
      1.772052,
      0.891422,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.158485,
      NULL,
      NULL,
      2.626153,
      2.302434,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0.092439,
      2,
      1.082903,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.903984,
      1,
      1.825126,
      1,
      1.072525,
      0.468030,
      1.935848,
      1.531746,
      1,
      1.552437,
      0.189196,
      1.195601,
      1.088544,
      0.773341,
      0.795629,
      0.902844,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.158333,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.627558,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.597852,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.922345,
      NULL,
      0,
      NULL,
      NULL,
      1.659794,
      1.599960,
      0,
      0,
      '00002',
      '',
      '',
      0.457713,
      '',
      NULL,
      '',
      1.530627,
      NULL,
      '',
      '',
      1,
      3,
      NULL,
      0.477233,
      2,
      NULL,
      NULL,
      2,
      1);
commit;
end;
/


