set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8814999';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2002-12-19 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '10243431',
      34.029083,
      72.748831,
      '1204142',
      317.426787,
      1,
      NULL,
      1,
      '142210',
      0.913937,
      ' 3-17-1989',
      44.832965,
      47,
      0.610288,
      NULL,
      1,
      NULL,
      0.640482,
      NULL,
      1,
      1.144060,
      NULL,
      0,
      1.736844,
      1,
      2.872581,
      1,
      0.531316,
      1,
      1,
      0,
      1.421762,
      1.745995,
      1,
      1.829627,
      0,
      0,
      2.594535,
      1,
      3,
      NULL,
      0.228876,
      1.635197,
      NULL,
      NULL,
      0.373130,
      NULL,
      NULL,
      1,
      NULL,
      1.670757,
      1.794308,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.712770,
      0,
      1,
      1,
      0,
      1.806031,
      0.155008,
      1.042599,
      0.279541,
      1,
      0,
      1.854503,
      NULL,
      1.856801,
      NULL,
      1,
      0.593949,
      1,
      NULL,
      0,
      1.363946,
      1,
      1,
      0,
      NULL,
      1,
      1.956599,
      5.823581,
      NULL,
      0,
      0.118251,
      1.026981,
      1.039448,
      3.574921,
      1,
      5,
      5.448897,
      NULL,
      4,
      4,
      NULL,
      0,
      1,
      5.165231,
      NULL,
      0,
      4,
      NULL,
      NULL,
      NULL,
      3.692191,
      1.542438,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.475867,
      0,
      NULL,
      0,
      NULL,
      0.676226,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      7,
      NULL,
      1.508815,
      0.543037,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.450197,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.442269,
      NULL,
      0,
      NULL,
      1.797499,
      NULL,
      NULL,
      NULL,
      1,
      2.503875,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      2.689636,
      0.668362,
      1.844188,
      0,
      0,
      3.471081,
      1.751179,
      3,
      NULL,
      1.249522,
      NULL,
      0.998658,
      0.273833,
      1,
      1.258893,
      0.870974,
      NULL,
      0.794361,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.419062,
      1.241486,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.873785,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      1.208998,
      '00422',
      NULL,
      NULL,
      NULL,
      '',
      '',
      '',
      1,
      '',
      '',
      '',
      NULL,
      NULL,
      NULL,
      3.299012,
      3.499356,
      1.173168,
      2,
      1.056556,
      1);
commit;
end;
/


