set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8814999';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2003-6-12 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '003',
      '13301224',
      79,
      33.196431,
      '2112124',
      237.524171,
      5,
      1,
      NULL,
      NULL,
      3.390285,
      ' 7-14-2000',
      23.952247,
      4,
      1.716988,
      NULL,
      0,
      NULL,
      0,
      0,
      1,
      NULL,
      1.414084,
      0.283089,
      NULL,
      1.662963,
      0.687801,
      0.958008,
      0.410332,
      NULL,
      NULL,
      0.251061,
      0.128239,
      0,
      NULL,
      0,
      NULL,
      NULL,
      3,
      NULL,
      1,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.025373,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.139406,
      1.487099,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.679611,
      1,
      1,
      0,
      NULL,
      3.930700,
      1,
      1,
      0.892007,
      0,
      NULL,
      1,
      NULL,
      1.416016,
      0,
      NULL,
      1,
      1,
      0,
      NULL,
      0.617770,
      1.828050,
      1,
      NULL,
      0,
      NULL,
      1,
      0.574520,
      NULL,
      1,
      0,
      NULL,
      0,
      0,
      0,
      0,
      NULL,
      NULL,
      2,
      4.138699,
      0,
      2.004787,
      3,
      1.372571,
      2,
      0,
      2,
      NULL,
      0.270424,
      NULL,
      NULL,
      1.826207,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0,
      0,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.441875,
      NULL,
      1,
      3.236651,
      1.524793,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.479324,
      1.987006,
      2,
      NULL,
      3.343743,
      3.698633,
      1.188884,
      0.622712,
      5,
      NULL,
      2,
      0,
      1,
      1.788908,
      NULL,
      NULL,
      1,
      1,
      1.057830,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.906136,
      2,
      0,
      0,
      1.875596,
      3,
      0,
      1.194455,
      0.667930,
      NULL,
      1.034093,
      0.165896,
      1,
      0,
      0,
      0,
      1.025075,
      0,
      NULL,
      0.832856,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.674711,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0.614515,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.589656,
      NULL,
      0,
      1,
      1,
      0,
      2,
      NULL,
      '',
      '',
      1.088330,
      '',
      '',
      '',
      0.043142,
      NULL,
      '',
      '',
      5.625676,
      NULL,
      0,
      0.261533,
      1.755891,
      5.840420,
      1.712132,
      0.122064,
      3.520330);
commit;
end;
/


