set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8814999';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2005-1-18 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4000',
      '14312404',
      6.308615,
      53,
      '3024302',
      311.883430,
      5,
      NULL,
      0,
      '311020',
      NULL,
      NULL,
      19,
      48,
      1,
      NULL,
      NULL,
      0.547573,
      0.852407,
      1.180200,
      0.375140,
      NULL,
      3.881559,
      0,
      0,
      1,
      3,
      NULL,
      0.276974,
      1.965503,
      1,
      0,
      0,
      1,
      0.146960,
      0,
      NULL,
      0.986385,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0,
      1.615236,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.068537,
      1.465132,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.415068,
      1.116173,
      NULL,
      0.203520,
      NULL,
      1,
      NULL,
      1.855183,
      0,
      0.063483,
      NULL,
      0,
      1.948872,
      0,
      1.018497,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.545116,
      NULL,
      1.821127,
      0.629899,
      0.764697,
      0,
      1.068237,
      0,
      0.092507,
      1.230076,
      0,
      NULL,
      0.662276,
      3,
      NULL,
      1,
      3.861165,
      NULL,
      1.627842,
      2,
      5,
      1,
      NULL,
      2.655711,
      2,
      1,
      1,
      NULL,
      NULL,
      NULL,
      5.318874,
      1.530740,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.105514,
      0,
      0,
      1,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.328960,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.562427,
      1.275887,
      0,
      NULL,
      NULL,
      NULL,
      2.488785,
      1,
      0,
      2.030817,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.519305,
      3.163324,
      0.706931,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1,
      1.856029,
      1,
      0,
      3.167626,
      NULL,
      2,
      1,
      1.544002,
      0,
      0.553955,
      1.231378,
      0.485952,
      0.277841,
      1.149334,
      1.624601,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.656472,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.116421,
      0,
      0,
      NULL,
      1,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.752912,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0,
      NULL,
      NULL,
      1,
      NULL,
      0,
      0,
      2,
      '41040',
      '04201',
      NULL,
      1,
      '',
      '',
      '',
      1.562210,
      NULL,
      '',
      '',
      5.695138,
      2,
      1,
      5,
      1.265065,
      0,
      1.072925,
      0.693320,
      0);
commit;
end;
/


