set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9716130';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2005-6-14 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '12333414',
      71.089187,
      10.244502,
      '1124214',
      NULL,
      5,
      0.528680,
      2,
      NULL,
      0.318799,
      ' 7-19-1998',
      44,
      16,
      1,
      NULL,
      1,
      1.797688,
      NULL,
      NULL,
      0,
      1,
      0,
      3,
      1,
      1.651145,
      1,
      1.227980,
      3,
      1,
      NULL,
      0,
      7,
      0.468265,
      0.106038,
      1.200107,
      0.001044,
      NULL,
      3,
      0,
      0,
      2.317813,
      0.866670,
      1,
      NULL,
      NULL,
      1.027660,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.360835,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0.772098,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.886992,
      3.339210,
      4,
      5,
      NULL,
      NULL,
      NULL,
      1.159050,
      1.284372,
      0,
      1,
      NULL,
      0.047331,
      1,
      1.278915,
      1.066135,
      1,
      NULL,
      0.231335,
      0,
      NULL,
      2.571560,
      6.672428,
      1,
      6.316922,
      1,
      4,
      NULL,
      1.308079,
      NULL,
      0.375176,
      0.894997,
      NULL,
      3.632199,
      6.152021,
      6,
      NULL,
      3,
      0,
      9.887329,
      NULL,
      1,
      5.317650,
      7,
      NULL,
      3.994168,
      0.958397,
      0,
      0,
      6,
      1.069882,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2,
      1,
      1,
      3.888679,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.621190,
      NULL,
      NULL,
      1.347434,
      3.037139,
      1.515716,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.632769,
      2,
      3.666458,
      1,
      6.773735,
      NULL,
      7,
      0,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      1,
      5,
      1.838108,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      3.164299,
      1.157745,
      2,
      2,
      NULL,
      NULL,
      0.018082,
      2.825226,
      NULL,
      1,
      0,
      0.567228,
      0.703619,
      1.267118,
      NULL,
      0,
      1.010696,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3,
      '23100',
      '02021',
      '',
      0.555372,
      '',
      '',
      '',
      NULL,
      '',
      '',
      '',
      7,
      3.720375,
      2,
      NULL,
      2,
      1.353344,
      0.714738,
      0,
      2);
commit;
end;
/


