set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9329516';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1994-5-13 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2',
      '4',
      NULL,
      NULL,
      '2320311',
      11,
      4,
      NULL,
      3,
      '023430',
      NULL,
      ' 3-18-1992',
      1.684620,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      1.040405,
      0.618561,
      3,
      NULL,
      0,
      NULL,
      1,
      1.783029,
      0.212602,
      1,
      2.716419,
      0,
      NULL,
      NULL,
      NULL,
      0.583473,
      1.288393,
      1,
      0.913757,
      0.591962,
      0,
      4.687324,
      2,
      0.854959,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      0,
      1.291497,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.354059,
      1.354601,
      0.840108,
      0.506281,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.203535,
      0.596869,
      1,
      1,
      2.368415,
      1.674244,
      0,
      2.280608,
      1,
      1.024999,
      1,
      NULL,
      1.855660,
      0,
      0.355310,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1.267456,
      0,
      1,
      0.317811,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.356078,
      1,
      0,
      1.827501,
      NULL,
      0,
      3.726036,
      3,
      0,
      0,
      0,
      1.983701,
      2,
      1.927892,
      0,
      0,
      NULL,
      NULL,
      NULL,
      4,
      1.163895,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.920531,
      1,
      NULL,
      1.752498,
      0.276851,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.113317,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.776695,
      1,
      NULL,
      NULL,
      1.048037,
      0,
      0.857641,
      NULL,
      NULL,
      NULL,
      1.783003,
      NULL,
      0.229982,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.809556,
      2.892210,
      1,
      0,
      NULL,
      0,
      0.116948,
      1.693556,
      0.206153,
      1,
      1,
      1.587017,
      1,
      0.371523,
      1.364642,
      0.737604,
      0.859056,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.733736,
      1.506116,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.007639,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.456084,
      NULL,
      NULL,
      NULL,
      NULL,
      1.300179,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.137960,
      0,
      NULL,
      1,
      NULL,
      NULL,
      1,
      3,
      '43104',
      '',
      '',
      0,
      '',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


