set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9329516';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1997-5-05 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '210',
      '40',
      37.788566,
      1.028222,
      '4432324',
      52.251506,
      4,
      3.213446,
      3,
      '140344',
      NULL,
      ' 6-17-1987',
      67.453735,
      NULL,
      0,
      NULL,
      1,
      1,
      0.424427,
      NULL,
      1.795192,
      0,
      0.059856,
      0,
      0.097705,
      0.174195,
      0.832729,
      NULL,
      NULL,
      1.659719,
      1.873493,
      0,
      0.922969,
      0,
      7.124914,
      4,
      0.856760,
      1,
      0.246417,
      0,
      0.401363,
      0.835742,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.977042,
      1,
      1.965862,
      3.024831,
      1,
      0,
      3,
      1,
      1.582855,
      NULL,
      0,
      1,
      1.227646,
      0,
      1.397602,
      1.345221,
      0,
      2,
      NULL,
      1,
      NULL,
      1,
      0,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.183254,
      NULL,
      NULL,
      6,
      3,
      NULL,
      NULL,
      NULL,
      1.335663,
      NULL,
      0.617121,
      0,
      1,
      1.190169,
      1.085895,
      NULL,
      1.708394,
      0.195665,
      0,
      1.994834,
      1.481982,
      NULL,
      NULL,
      1.778191,
      0.521479,
      0,
      NULL,
      1,
      1,
      0.938813,
      1.761803,
      0.375985,
      5.177527,
      0.038313,
      1,
      3.708012,
      3,
      0,
      1,
      NULL,
      2,
      0.412776,
      7,
      4,
      5,
      0,
      NULL,
      NULL,
      1.424783,
      0,
      0,
      0,
      0,
      0.831713,
      3,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      2,
      NULL,
      NULL,
      0.306380,
      0,
      0.916007,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.846743,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3,
      3.028840,
      1.199978,
      0.808860,
      NULL,
      1.063546,
      5,
      NULL,
      5.804057,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.846730,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1,
      NULL,
      0.940850,
      1,
      NULL,
      3,
      0,
      3,
      3,
      1.510635,
      0.714303,
      0,
      0.131108,
      1.706446,
      1,
      1.187244,
      1.240528,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.845772,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1,
      NULL,
      0,
      NULL,
      NULL,
      1,
      0.338654,
      '14433',
      '',
      '',
      1.435353,
      '',
      '',
      '',
      1.197243,
      '',
      '',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


