set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9329516';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1998-12-08 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      47,
      4,
      NULL,
      61.607675,
      4,
      2,
      2,
      '322403',
      NULL,
      ' 0- 1-1980',
      83,
      26,
      1,
      NULL,
      3,
      NULL,
      1.195566,
      1.453341,
      NULL,
      0,
      1.959202,
      1.259708,
      NULL,
      0,
      7.675712,
      NULL,
      1.669835,
      1,
      1.189377,
      1,
      0.356319,
      0.524238,
      NULL,
      1,
      0.286051,
      1.595481,
      7.972361,
      0,
      NULL,
      1.104507,
      1,
      1.963159,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.538729,
      1.540653,
      1.866404,
      0.561175,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.242878,
      1.581892,
      0.126482,
      1.890612,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2,
      0.289089,
      1,
      3,
      NULL,
      1,
      1,
      0.149649,
      NULL,
      NULL,
      1.634048,
      0,
      0.531515,
      1,
      1,
      NULL,
      0,
      1.687665,
      NULL,
      1,
      1,
      NULL,
      0,
      0,
      0.672582,
      1.624905,
      1.189097,
      4.283690,
      0.503688,
      NULL,
      1.084909,
      1,
      NULL,
      1,
      NULL,
      NULL,
      0.238530,
      4,
      0,
      0.776575,
      1.026288,
      1,
      NULL,
      3,
      0,
      1,
      1.350998,
      0.845119,
      0,
      0.829359,
      0.383469,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.936935,
      1.625765,
      1,
      1,
      0.914025,
      0,
      1.911921,
      1.242132,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      3.104096,
      1.123720,
      1,
      8,
      0,
      2,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      1.259613,
      1,
      0.991510,
      NULL,
      NULL,
      NULL,
      0.583044,
      3,
      0.154387,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0,
      0,
      1,
      1,
      NULL,
      1,
      1.386347,
      0,
      0.248617,
      NULL,
      1.979687,
      0.503106,
      1.998273,
      1.545249,
      0.464503,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.958171,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.227850,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      2.589064,
      0.012538,
      NULL,
      NULL,
      0.303018,
      NULL,
      0,
      2,
      0,
      NULL,
      NULL,
      '',
      0,
      '',
      '',
      '',
      1,
      '',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


