set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9329516';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2000-5-06 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '403',
      '03232022',
      20,
      62.377160,
      NULL,
      35,
      5,
      0,
      0,
      NULL,
      4.261910,
      ' 6-26-1976',
      83.792580,
      10,
      NULL,
      NULL,
      1,
      0,
      1,
      1,
      1,
      2.669853,
      NULL,
      NULL,
      0,
      NULL,
      3,
      NULL,
      0,
      1,
      0,
      3.918917,
      3.728844,
      0,
      1,
      0.578788,
      1,
      NULL,
      6.435124,
      0,
      2.861784,
      1,
      1.305051,
      NULL,
      NULL,
      NULL,
      0.723236,
      NULL,
      NULL,
      2.193793,
      1.263667,
      1.774667,
      0.987912,
      NULL,
      0,
      0.041316,
      NULL,
      NULL,
      NULL,
      1.153613,
      NULL,
      1,
      1.528887,
      1,
      1.734435,
      3.275458,
      3,
      1.678675,
      1,
      NULL,
      3,
      1.908451,
      0,
      NULL,
      1.918256,
      0.365296,
      NULL,
      NULL,
      1.815317,
      NULL,
      NULL,
      NULL,
      7,
      NULL,
      1,
      4,
      0,
      0,
      0,
      1.752802,
      1.238494,
      0,
      1.830498,
      NULL,
      NULL,
      1,
      1.175576,
      NULL,
      1.144626,
      1.064877,
      NULL,
      0.569538,
      0.340045,
      NULL,
      1,
      NULL,
      0,
      1,
      NULL,
      1,
      0.382614,
      0,
      NULL,
      0,
      1.672690,
      1,
      NULL,
      7.613457,
      0.250878,
      1,
      6.372867,
      0,
      NULL,
      2.955070,
      NULL,
      1,
      NULL,
      0.505826,
      1.460898,
      2,
      0,
      0.763916,
      5,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.095256,
      1.727253,
      NULL,
      NULL,
      0.722920,
      NULL,
      1.101045,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.987527,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.027926,
      0.502455,
      1,
      2.854377,
      0.321918,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0.917444,
      NULL,
      1.813910,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      2.366881,
      NULL,
      NULL,
      NULL,
      0,
      1,
      2.302293,
      2.311913,
      NULL,
      NULL,
      0.185633,
      1.354392,
      1,
      NULL,
      NULL,
      0,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3,
      '24122',
      '',
      NULL,
      1.346577,
      '',
      '',
      NULL,
      0,
      '',
      '',
      '',
      2.613533,
      2.255911,
      2,
      NULL,
      0.692989,
      2.178470,
      NULL,
      NULL,
      0.743795);
commit;
end;
/


