set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9329516';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2000-11-09 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      67,
      5,
      '0322113',
      13.784583,
      1,
      NULL,
      3,
      '324223',
      2,
      ' 3-10-1998',
      NULL,
      210,
      0,
      NULL,
      1,
      0,
      0.404707,
      NULL,
      1.113205,
      3.136986,
      1,
      1.889763,
      3.573809,
      0,
      0.019832,
      0,
      1.405207,
      0,
      1.733560,
      NULL,
      3,
      1,
      0.659325,
      1,
      0,
      1.886663,
      5,
      1,
      2.043950,
      3,
      NULL,
      1,
      NULL,
      NULL,
      0.859257,
      NULL,
      NULL,
      2.194644,
      0,
      1,
      NULL,
      1,
      0,
      1.962677,
      1,
      1.064904,
      NULL,
      NULL,
      0.943525,
      0,
      0.608705,
      1.306983,
      1,
      3,
      2,
      1,
      0,
      NULL,
      3,
      NULL,
      1,
      2,
      0.421607,
      1,
      NULL,
      NULL,
      0.404454,
      NULL,
      NULL,
      NULL,
      0.326112,
      0,
      NULL,
      5,
      0.087736,
      1.723382,
      0,
      1.076902,
      1.659879,
      0.877109,
      1,
      NULL,
      1,
      1.555019,
      0,
      0.661490,
      0,
      1.567346,
      NULL,
      1.780408,
      1,
      NULL,
      NULL,
      1,
      0,
      0,
      NULL,
      0.081763,
      NULL,
      1.135745,
      1.180839,
      1,
      0,
      1.026443,
      1,
      1.126872,
      9.224166,
      NULL,
      NULL,
      0.705599,
      NULL,
      NULL,
      3.806321,
      4.241136,
      NULL,
      0.820380,
      NULL,
      1.921129,
      1.427793,
      0.165706,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.209137,
      0.467825,
      1,
      NULL,
      2.266224,
      1,
      1.654227,
      1.611222,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.648181,
      NULL,
      NULL,
      4.993836,
      1.271682,
      0,
      0.867056,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      3.508675,
      1,
      1,
      1,
      NULL,
      NULL,
      1,
      2,
      NULL,
      1,
      0,
      1,
      1.150808,
      1.924410,
      0.378803,
      0,
      1,
      1,
      1.698529,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.339873,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.448129,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1.352132,
      0.469493,
      0,
      NULL,
      0.767630,
      0,
      1.823110,
      2,
      NULL,
      '23204',
      '',
      '',
      1,
      '',
      '',
      '',
      1,
      '',
      '',
      '',
      3.500862,
      0,
      2,
      1.289230,
      NULL,
      1,
      0.294793,
      2.744625,
      1);
commit;
end;
/


