set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9329516';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-5-25 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      49,
      '3201411',
      NULL,
      4,
      NULL,
      2,
      '203002',
      NULL,
      ' 4-16-1983',
      NULL,
      152.078605,
      1,
      NULL,
      NULL,
      0.633910,
      3.754536,
      NULL,
      0.859441,
      0,
      0,
      0.906198,
      1,
      1.548066,
      NULL,
      1,
      0.417719,
      NULL,
      0.529533,
      5.376345,
      4,
      NULL,
      2.815642,
      4,
      0,
      0,
      NULL,
      0,
      NULL,
      1.094553,
      3,
      0,
      NULL,
      NULL,
      0.212487,
      NULL,
      NULL,
      0,
      NULL,
      0.929487,
      3.220206,
      NULL,
      0.350387,
      NULL,
      1.397710,
      0.576311,
      3.488922,
      NULL,
      1.336601,
      NULL,
      1.920530,
      1,
      0,
      0,
      1.570093,
      0.515688,
      1,
      1.034806,
      0.305659,
      5.204555,
      0,
      1,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.756553,
      0.977867,
      1.500635,
      1.828035,
      2.116565,
      1,
      NULL,
      0,
      0.991342,
      1.761895,
      0,
      NULL,
      1,
      1.281716,
      1,
      1.867378,
      0,
      NULL,
      1,
      NULL,
      0.550163,
      0,
      NULL,
      0,
      1.666345,
      0,
      4.274567,
      NULL,
      0.917406,
      NULL,
      1.697677,
      0.033847,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      9.522216,
      4.391511,
      0,
      0.602319,
      4,
      0,
      4.672187,
      0,
      0,
      1.304707,
      0,
      2,
      NULL,
      1.013035,
      6.835390,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.878064,
      NULL,
      NULL,
      0,
      NULL,
      1.304017,
      1.208697,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0.306170,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.286841,
      0,
      1.567922,
      3.869319,
      1,
      0,
      0.819005,
      NULL,
      NULL,
      NULL,
      0.882682,
      0.915952,
      0.998039,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.818668,
      2,
      NULL,
      NULL,
      1.586193,
      NULL,
      0.361279,
      1,
      NULL,
      0,
      0.898710,
      0.903062,
      0.536971,
      0.304859,
      0,
      NULL,
      0.767411,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1.428840,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.474418,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.028819,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.873261,
      NULL,
      0,
      0.907041,
      1,
      2,
      NULL,
      NULL,
      '',
      NULL,
      1.135813,
      '',
      '',
      '',
      0,
      '',
      '',
      NULL,
      0,
      3.526845,
      0.204073,
      3.883826,
      NULL,
      1,
      2.004940,
      0,
      3.903329);
commit;
end;
/


