set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9329516';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2002-1-02 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '321',
      '03012233',
      52,
      14,
      '0034323',
      37.810633,
      NULL,
      0.048540,
      0,
      '132302',
      0.658940,
      NULL,
      62.373424,
      126.814655,
      1,
      NULL,
      NULL,
      0.307440,
      1.880461,
      1,
      1,
      0,
      0.821073,
      NULL,
      NULL,
      1.844173,
      3,
      0,
      1.723717,
      5,
      1,
      NULL,
      NULL,
      1,
      3,
      7,
      4.881980,
      0.310647,
      0,
      1,
      NULL,
      NULL,
      3.938790,
      1,
      NULL,
      NULL,
      1.544472,
      NULL,
      NULL,
      3.632063,
      0,
      1.311114,
      1,
      NULL,
      0,
      2,
      1,
      NULL,
      1.419208,
      1.434967,
      NULL,
      0.688895,
      NULL,
      0.713590,
      NULL,
      1.353492,
      1.863270,
      NULL,
      1,
      NULL,
      1.164363,
      3.439486,
      NULL,
      0,
      3,
      1,
      NULL,
      NULL,
      1.274892,
      NULL,
      NULL,
      0.898727,
      1.351565,
      1,
      1,
      4.448500,
      1.682764,
      NULL,
      0.988001,
      0,
      1.309032,
      0.482030,
      NULL,
      1.797500,
      NULL,
      1,
      0.213354,
      1,
      1.438981,
      1,
      NULL,
      1,
      1,
      3.048850,
      1,
      1,
      0,
      5.895556,
      0.257231,
      1,
      NULL,
      0,
      0,
      1.425766,
      1,
      1.807607,
      1,
      1.719969,
      7.867537,
      0,
      1.241593,
      NULL,
      5.169910,
      1.584082,
      0,
      3,
      1,
      1,
      0,
      0,
      1.204198,
      1.536972,
      6,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1,
      2,
      NULL,
      0.779842,
      0.114399,
      0.044793,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0.417882,
      2.446051,
      0,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.231377,
      1,
      0.412866,
      NULL,
      1.813682,
      0,
      1,
      NULL,
      NULL,
      NULL,
      1.535433,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.092781,
      1.424197,
      2.987766,
      3,
      0.794063,
      0,
      1.289391,
      1.162755,
      2,
      1.107896,
      2,
      1,
      NULL,
      NULL,
      0,
      1,
      0,
      0.005403,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.496306,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.941652,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.235500,
      1,
      NULL,
      1,
      0.428062,
      0,
      2,
      1,
      '33442',
      '',
      '',
      0.014287,
      '',
      NULL,
      '',
      0.850769,
      NULL,
      NULL,
      '',
      3.996836,
      3,
      NULL,
      2,
      NULL,
      1.824613,
      1,
      1.396595,
      1);
commit;
end;
/


