set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9329516';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2002-7-24 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '311',
      '12001033',
      79.556281,
      34.333688,
      NULL,
      137,
      6,
      3,
      3,
      NULL,
      0.601277,
      '11-19-1993',
      86,
      79.844531,
      1,
      NULL,
      NULL,
      1.895936,
      3.778051,
      1,
      0.318542,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.522682,
      1.695068,
      1.838036,
      6.177294,
      1.824374,
      1.426913,
      NULL,
      0,
      0,
      0,
      1,
      NULL,
      0,
      NULL,
      1,
      2.813293,
      4,
      NULL,
      NULL,
      NULL,
      1.771283,
      NULL,
      NULL,
      4,
      0,
      1,
      3,
      0,
      0,
      3.569120,
      0.931258,
      NULL,
      NULL,
      0.840327,
      1,
      1,
      0,
      0.822303,
      0.016403,
      3,
      2.680063,
      2,
      NULL,
      1.303787,
      NULL,
      NULL,
      NULL,
      2,
      1.610829,
      0,
      NULL,
      NULL,
      0.008621,
      NULL,
      NULL,
      3.544468,
      NULL,
      1.625587,
      1.753135,
      6.823208,
      1,
      0.417194,
      0.640767,
      1,
      1,
      1.648633,
      1,
      0.679383,
      0,
      NULL,
      0,
      0,
      NULL,
      1,
      NULL,
      NULL,
      1.563757,
      5.862747,
      NULL,
      0,
      1.083556,
      NULL,
      NULL,
      1.394542,
      0.478629,
      1.405625,
      1.548660,
      1,
      0.678018,
      NULL,
      NULL,
      6.012279,
      9.700358,
      1,
      NULL,
      NULL,
      6.368051,
      1.105290,
      0,
      6,
      1,
      0.242444,
      NULL,
      NULL,
      1,
      0.866954,
      4.291505,
      0.178800,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.454340,
      1,
      0,
      NULL,
      0,
      1.117272,
      0.929627,
      0.372680,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.776870,
      NULL,
      NULL,
      NULL,
      NULL,
      4.316742,
      NULL,
      0.443626,
      NULL,
      1,
      3.047446,
      1.078498,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0,
      1,
      0.100480,
      2,
      0,
      NULL,
      NULL,
      NULL,
      1.045985,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.731722,
      2,
      0.460578,
      2,
      0.455219,
      0.341348,
      1.061246,
      0.807824,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.186308,
      0.389787,
      0,
      1.971461,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.771762,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.464464,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.187902,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3.834533,
      0.579838,
      NULL,
      2.444387,
      1.445164,
      1,
      NULL,
      0.301222,
      NULL,
      '02104',
      '',
      0,
      '',
      '',
      '',
      0,
      NULL,
      '',
      '',
      5,
      1.259757,
      3.460914,
      1.910733,
      3.098703,
      1,
      3.498880,
      NULL,
      3);
commit;
end;
/


