set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9329516';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2003-1-06 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '11144341',
      56,
      25.377471,
      '0331103',
      NULL,
      6,
      0,
      1,
      NULL,
      3.096395,
      ' 7-11-1979',
      59,
      139,
      0,
      NULL,
      3.507504,
      3,
      1,
      NULL,
      1,
      0.202032,
      NULL,
      1.167490,
      2,
      1.641064,
      NULL,
      1.593021,
      0,
      NULL,
      NULL,
      1.480402,
      7.361893,
      1.365538,
      4.721623,
      7,
      0.751108,
      1.622322,
      6.997663,
      1,
      2.851730,
      1.449891,
      NULL,
      0.906324,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.271636,
      NULL,
      0.861738,
      1.929742,
      1.784626,
      NULL,
      NULL,
      2,
      0,
      3.059984,
      2,
      0.828182,
      0.898495,
      0,
      NULL,
      0.021734,
      3.459388,
      3.123547,
      2.784372,
      0.463632,
      0,
      NULL,
      5.399692,
      1,
      2,
      5.231145,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1,
      NULL,
      NULL,
      1,
      1,
      0.428524,
      NULL,
      0,
      1,
      0,
      NULL,
      0.736441,
      0,
      NULL,
      1.492925,
      NULL,
      NULL,
      1.532681,
      NULL,
      NULL,
      1,
      1,
      0,
      NULL,
      0.266234,
      1,
      1,
      1,
      1.993719,
      NULL,
      NULL,
      0,
      1,
      2.191897,
      NULL,
      1,
      7.382022,
      4,
      2.307799,
      2,
      4,
      1.619408,
      1,
      1,
      0,
      0,
      NULL,
      1.697094,
      2.758828,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      NULL,
      2.897360,
      1.432768,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      2.601164,
      NULL,
      NULL,
      0.460919,
      1,
      NULL,
      0,
      0,
      0.259019,
      NULL,
      1.519361,
      0,
      NULL,
      4,
      1.471491,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      5.475031,
      0.805292,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.953924,
      2,
      0.534010,
      1.626299,
      NULL,
      1.161185,
      3,
      1,
      NULL,
      2.037828,
      1.026830,
      NULL,
      0.865596,
      0,
      0.800586,
      1,
      0,
      0.140556,
      0.085262,
      1.532536,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1.127877,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.870025,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.563911,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.756525,
      NULL,
      NULL,
      NULL,
      NULL,
      1.200711,
      NULL,
      NULL,
      NULL,
      NULL,
      1.026630,
      0,
      1.075623,
      NULL,
      1,
      0.245183,
      1.212091,
      0,
      5.530055,
      '32411',
      '23404',
      '',
      0.403561,
      '',
      '',
      '',
      NULL,
      NULL,
      '',
      '',
      NULL,
      2.866823,
      3.980780,
      0,
      1,
      5.430575,
      1.672894,
      2,
      2.354926);
commit;
end;
/


