set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9329516';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2003-7-08 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3410',
      '11230423',
      17.799153,
      44,
      '4110233',
      29,
      6,
      NULL,
      0,
      NULL,
      5,
      ' 0-13-1984',
      NULL,
      222.952139,
      1.408695,
      NULL,
      0.860083,
      NULL,
      1.794662,
      NULL,
      0.132294,
      1,
      0,
      2.500475,
      1.971452,
      0.485022,
      2.824932,
      0.860320,
      0,
      0,
      1.090979,
      2,
      3.673537,
      0.625909,
      1,
      2.732445,
      0,
      1.639309,
      NULL,
      0,
      4.463672,
      NULL,
      1.682225,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      3,
      0,
      2.578765,
      0,
      0.656645,
      1,
      0,
      1.349266,
      0.257297,
      NULL,
      3.235574,
      1,
      NULL,
      1.813774,
      2,
      1.884152,
      0.162529,
      NULL,
      0.536049,
      0.656301,
      2.013370,
      2,
      1,
      NULL,
      NULL,
      1.149474,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.149250,
      6.415767,
      1.441476,
      NULL,
      0.635005,
      1,
      0,
      1.280614,
      1,
      0,
      0,
      1.507396,
      1,
      1.875582,
      1.629055,
      0.106332,
      NULL,
      1.714266,
      NULL,
      5,
      0.947845,
      1,
      3.947243,
      5,
      NULL,
      NULL,
      1,
      1,
      1.419350,
      0,
      0.195551,
      0,
      0,
      6.322205,
      5.347346,
      3.984795,
      2,
      7,
      7.981343,
      3,
      NULL,
      6,
      0.443385,
      NULL,
      0,
      2.825571,
      0,
      NULL,
      6,
      1.651455,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.559916,
      0.510504,
      0,
      0,
      1,
      4,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1,
      0.445108,
      3,
      2.022642,
      0.504225,
      0,
      1.155536,
      3.875498,
      0.642363,
      1,
      0,
      1,
      NULL,
      NULL,
      NULL,
      1.734200,
      5,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.612657,
      1.602302,
      NULL,
      1,
      0.256403,
      0,
      NULL,
      NULL,
      0.685813,
      2.425272,
      0.334362,
      0,
      0.975245,
      1.205414,
      1,
      1.965710,
      0.364641,
      0.110844,
      1,
      1.698661,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.614105,
      1.173278,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.098147,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0.781311,
      NULL,
      NULL,
      NULL,
      NULL,
      3.484883,
      0,
      1,
      NULL,
      1,
      0,
      0.705032,
      NULL,
      1.205484,
      '43010',
      NULL,
      '',
      0.278594,
      '',
      NULL,
      '',
      0.267968,
      '',
      '',
      '',
      0,
      0,
      NULL,
      0.651937,
      2,
      3.946083,
      3.319843,
      1.483831,
      2);
commit;
end;
/


