set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9329516';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2003-11-26 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2223',
      '20141333',
      NULL,
      72,
      '3343220',
      38,
      NULL,
      NULL,
      0,
      '414101',
      4,
      '11-12-2000',
      NULL,
      128.922710,
      1.704610,
      NULL,
      3,
      0,
      3.705237,
      NULL,
      NULL,
      1.481920,
      0,
      NULL,
      0.008263,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3,
      2.763069,
      NULL,
      2.763315,
      7.346817,
      NULL,
      0.605412,
      6,
      0,
      1.378752,
      2,
      3.846545,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      4.028781,
      0,
      3,
      1,
      1,
      3,
      2,
      0,
      2.377146,
      NULL,
      1.960092,
      0.541347,
      2.331576,
      1,
      1,
      2.432539,
      0.234696,
      NULL,
      3.484253,
      1,
      1.476032,
      1,
      0,
      0,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.952300,
      7.750351,
      1.724039,
      0.300785,
      4,
      1.947791,
      NULL,
      0.796853,
      0,
      NULL,
      1.496752,
      0.318999,
      1.086538,
      1,
      1,
      1,
      0.407937,
      NULL,
      1,
      NULL,
      0,
      NULL,
      1,
      NULL,
      1.498923,
      0,
      2.678989,
      0,
      NULL,
      0.003655,
      NULL,
      NULL,
      1.632352,
      1.777221,
      0,
      1,
      0.497019,
      8.786116,
      5.077117,
      2.212887,
      4,
      5.023059,
      3.751591,
      NULL,
      6.685157,
      NULL,
      0,
      0.484685,
      0.683197,
      1.367791,
      1,
      NULL,
      0.570973,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.531294,
      0.424890,
      NULL,
      2,
      0.356187,
      2.211598,
      3,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.633024,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.293918,
      0.427943,
      2.389983,
      2.629151,
      2,
      0,
      0.323158,
      NULL,
      5.356574,
      NULL,
      0.589573,
      0,
      0,
      NULL,
      NULL,
      NULL,
      0,
      1.359711,
      0.394970,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.102579,
      NULL,
      NULL,
      3.566813,
      1.686901,
      NULL,
      NULL,
      1,
      NULL,
      1,
      3,
      1,
      NULL,
      0.008947,
      1.851907,
      NULL,
      1.384452,
      1.469268,
      1,
      1.226756,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.412026,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      3.991403,
      NULL,
      0,
      NULL,
      1,
      1.725600,
      0.080818,
      1,
      0,
      '03014',
      '23010',
      NULL,
      0,
      '',
      '',
      '',
      0.352346,
      NULL,
      '',
      NULL,
      2,
      0,
      3,
      NULL,
      0.323016,
      1,
      1,
      2.575470,
      2);
commit;
end;
/


