set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9329516';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2004-6-13 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1142',
      NULL,
      64,
      56,
      '2034432',
      16.073469,
      5,
      0,
      NULL,
      NULL,
      NULL,
      '11-27-1981',
      11,
      48.963093,
      NULL,
      NULL,
      1.147190,
      0.026138,
      2,
      0,
      0.165655,
      1,
      1,
      1.644204,
      0.515226,
      0.281643,
      7,
      1.263126,
      NULL,
      8.704468,
      1,
      1.873905,
      NULL,
      0.654599,
      1,
      NULL,
      NULL,
      NULL,
      7,
      0,
      0.064260,
      NULL,
      4.250181,
      1,
      NULL,
      NULL,
      1.393783,
      NULL,
      NULL,
      NULL,
      2.682891,
      1,
      2,
      NULL,
      1.691172,
      2.467725,
      NULL,
      0.083653,
      0.410205,
      0.689170,
      1.902336,
      NULL,
      1.993414,
      1,
      0,
      2,
      0.693054,
      0.382357,
      NULL,
      0,
      0,
      0.380934,
      1,
      2,
      1.831173,
      1.080308,
      NULL,
      NULL,
      1.249747,
      NULL,
      NULL,
      7,
      3,
      1,
      1.021646,
      NULL,
      1,
      0.828010,
      1.419373,
      0,
      NULL,
      1,
      0,
      0.419869,
      0.223379,
      1.625599,
      1,
      0.426035,
      0,
      NULL,
      NULL,
      0,
      1.619762,
      NULL,
      1,
      0.661802,
      1.056663,
      NULL,
      3.277840,
      NULL,
      NULL,
      NULL,
      NULL,
      0.016788,
      1.615531,
      1.010102,
      1.704287,
      3.602128,
      NULL,
      2,
      5.429723,
      NULL,
      5,
      5.897811,
      1.653812,
      2.917975,
      1.326524,
      1,
      0,
      2,
      1.737135,
      1,
      6,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.545030,
      NULL,
      2,
      1.851419,
      1,
      0.875077,
      0.307184,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.524770,
      NULL,
      NULL,
      NULL,
      NULL,
      1.110565,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1.509176,
      3.873312,
      0,
      NULL,
      NULL,
      0,
      1,
      1.138029,
      1,
      1.581176,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1.990884,
      1.823004,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2,
      2,
      2.237860,
      1.997940,
      NULL,
      3.806352,
      0,
      1.335134,
      3.560303,
      3,
      0,
      1.695733,
      NULL,
      0.128044,
      0.756288,
      1,
      NULL,
      NULL,
      0.261000,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.451617,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.456155,
      NULL,
      NULL,
      NULL,
      NULL,
      0.932904,
      0.511327,
      0,
      NULL,
      NULL,
      1,
      NULL,
      0,
      0,
      '34222',
      '01311',
      '',
      1.351655,
      '',
      NULL,
      NULL,
      1.281708,
      '',
      NULL,
      '',
      NULL,
      0,
      NULL,
      3.807121,
      1,
      2.083389,
      NULL,
      0,
      NULL);
commit;
end;
/


