set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9329516';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2004-11-18 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2123',
      NULL,
      51,
      5.530162,
      '1030200',
      180,
      NULL,
      3.099304,
      0,
      '343342',
      1.555443,
      NULL,
      12.272272,
      45,
      1,
      NULL,
      0,
      1,
      3,
      0,
      0,
      0.138721,
      1,
      0,
      0,
      1,
      6.436340,
      0,
      0.494856,
      7,
      NULL,
      NULL,
      2.447814,
      1.372352,
      1,
      7,
      0,
      1,
      0.558946,
      1,
      0.263632,
      NULL,
      NULL,
      1.463545,
      NULL,
      NULL,
      0.404516,
      NULL,
      NULL,
      2,
      0.686636,
      NULL,
      3.582067,
      0.429996,
      1.968603,
      NULL,
      2.786754,
      1.965850,
      0,
      0.880411,
      1,
      1,
      3,
      0.349886,
      0,
      2,
      0.301382,
      0.303462,
      1,
      1,
      0.115762,
      0.463216,
      0,
      NULL,
      3,
      0,
      NULL,
      NULL,
      1.113156,
      NULL,
      NULL,
      2,
      4.979536,
      1,
      0.185222,
      0,
      0,
      1,
      NULL,
      1.284730,
      1,
      0,
      NULL,
      1.767658,
      0.349747,
      1,
      0,
      1.497192,
      1.548783,
      0.189356,
      NULL,
      NULL,
      1,
      4,
      1,
      1,
      3,
      3.715946,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1.969991,
      0.421843,
      NULL,
      1,
      2,
      1,
      4,
      0,
      7.508622,
      3.443484,
      3,
      7,
      6,
      1,
      4,
      1,
      3.284780,
      0.039320,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.031035,
      1.541253,
      0,
      1,
      3.803789,
      1.156543,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.595116,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.143647,
      2.279883,
      0,
      NULL,
      NULL,
      NULL,
      1.159841,
      0.043136,
      4.574169,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0.787364,
      3.295707,
      1.498641,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.193649,
      3,
      0.999414,
      1.232251,
      NULL,
      3,
      1.522658,
      1,
      1.151911,
      1,
      3,
      0.328715,
      1,
      NULL,
      0,
      0,
      0,
      1.696473,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.093043,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.428983,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.801506,
      0.184515,
      1,
      NULL,
      1,
      NULL,
      1,
      2,
      NULL,
      NULL,
      '23412',
      '',
      0.030440,
      '',
      '',
      '',
      2.214019,
      '1213',
      '',
      '',
      0.115795,
      0,
      1.246139,
      1,
      0.894068,
      2,
      1.773567,
      NULL,
      0);
commit;
end;
/


