set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7812239';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1997-7-07 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '403',
      NULL,
      6,
      8,
      '0030201',
      6,
      NULL,
      NULL,
      2,
      '131200',
      4,
      ' 2-14-1980',
      119.188998,
      45,
      1,
      NULL,
      0,
      1,
      0,
      1,
      1.903742,
      3.415060,
      NULL,
      0,
      2,
      NULL,
      0.012329,
      0.258521,
      0.934353,
      1.257095,
      1.481797,
      1,
      0.140765,
      NULL,
      0,
      NULL,
      1,
      1.360277,
      1.628440,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.158331,
      1,
      0,
      1.353408,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.423576,
      1,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      1,
      0,
      7.297562,
      0,
      5,
      1.364435,
      1.348732,
      0,
      NULL,
      1.257710,
      1,
      4.047588,
      0,
      0,
      0.831810,
      1,
      1.053745,
      NULL,
      1.094590,
      2.958776,
      4,
      2,
      4,
      1,
      NULL,
      0.487782,
      NULL,
      1,
      2,
      4.328484,
      NULL,
      NULL,
      1.493422,
      0.320098,
      NULL,
      6.497951,
      2,
      8,
      2,
      NULL,
      NULL,
      4.953339,
      6,
      NULL,
      7,
      NULL,
      2,
      1.521102,
      1.531837,
      3,
      1.971292,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.597020,
      0,
      0,
      1,
      NULL,
      1.099938,
      0.095626,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.112102,
      NULL,
      NULL,
      NULL,
      NULL,
      0.324932,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.074383,
      3,
      1,
      NULL,
      NULL,
      NULL,
      1,
      1.689451,
      5.330256,
      3.081214,
      1.398391,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1.554315,
      2,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.799162,
      0.600678,
      1,
      0.631542,
      1,
      1,
      1,
      NULL,
      NULL,
      1,
      3.412300,
      1.786203,
      NULL,
      NULL,
      1,
      1,
      1,
      NULL,
      1.946834,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.167818,
      1.317176,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1.533030,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1,
      NULL,
      NULL,
      1,
      1,
      1.916722,
      0,
      0.485234,
      '44243',
      '04413',
      NULL,
      1.893860,
      NULL,
      '',
      '',
      0.770092,
      NULL,
      '',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


