set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7812239';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1998-1-17 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '321',
      NULL,
      41.388776,
      25,
      NULL,
      2,
      2,
      2.864208,
      0,
      '202014',
      1.967656,
      ' 4-21-1986',
      4.342536,
      36.435551,
      1.317385,
      NULL,
      5.010936,
      NULL,
      1.772387,
      1,
      1.009280,
      0.788766,
      0,
      0.710562,
      2.483641,
      NULL,
      3,
      0.980787,
      NULL,
      1,
      1,
      1.867467,
      0.278539,
      1,
      0.334128,
      1,
      1,
      0.393940,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.724740,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.768813,
      NULL,
      9,
      NULL,
      4.465956,
      1.339274,
      1.026466,
      1.172100,
      NULL,
      0.750774,
      1.055899,
      1,
      0.558053,
      0,
      0.446074,
      1.246556,
      0.514273,
      1,
      3,
      1.901787,
      1,
      1.312000,
      0,
      4.933134,
      2.973962,
      1.720759,
      8,
      0.627773,
      4.670510,
      1,
      7.881297,
      7.986687,
      6,
      2,
      0.993042,
      5,
      NULL,
      5,
      NULL,
      8.764014,
      4,
      NULL,
      8.912406,
      NULL,
      6,
      5,
      2,
      4,
      1.395996,
      0.185012,
      0,
      5,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.323990,
      NULL,
      0,
      1,
      0,
      1,
      0.217100,
      1.599605,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.169969,
      NULL,
      NULL,
      NULL,
      NULL,
      4.959902,
      0,
      NULL,
      0,
      3.707336,
      NULL,
      0.751927,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      6.689521,
      NULL,
      NULL,
      0,
      0,
      0.469924,
      NULL,
      NULL,
      NULL,
      1.764419,
      1.417895,
      0.455480,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.195041,
      0.538206,
      1.911002,
      1.738214,
      0.776934,
      2.117292,
      2.320552,
      NULL,
      0.094435,
      2,
      3.767011,
      1.918536,
      1,
      0.354556,
      0.001612,
      1.620736,
      1,
      1.539101,
      NULL,
      0.241181,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      4,
      '03322',
      '21420',
      '',
      0,
      '',
      '',
      '',
      NULL,
      NULL,
      NULL,
      '',
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


