set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7812239';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1999-12-07 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '242',
      '41044114',
      8,
      29.475000,
      NULL,
      NULL,
      4,
      NULL,
      NULL,
      '004202',
      4,
      ' 1- 8-1995',
      NULL,
      228,
      1.997689,
      NULL,
      0.511908,
      NULL,
      0.384067,
      NULL,
      0,
      NULL,
      1.406658,
      0,
      0,
      0.052740,
      NULL,
      0.986083,
      0.723119,
      1,
      1.772907,
      1,
      0.550892,
      0.762313,
      1,
      1.945303,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.978956,
      NULL,
      1.535739,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0.290518,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.298017,
      NULL,
      NULL,
      1,
      NULL,
      0,
      0.342802,
      NULL,
      0,
      0.589773,
      1.457418,
      1.073353,
      0,
      1,
      0,
      NULL,
      4,
      1,
      NULL,
      1.484538,
      5,
      NULL,
      1.794077,
      1.251639,
      9.486466,
      1.797761,
      9.944053,
      NULL,
      6,
      0,
      NULL,
      3.195301,
      NULL,
      7,
      3,
      2,
      5,
      NULL,
      NULL,
      2.521885,
      0,
      2.201909,
      NULL,
      1.615992,
      1,
      1.960461,
      0,
      1.594976,
      3,
      1.180381,
      NULL,
      4.646979,
      0.314007,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.333223,
      0,
      NULL,
      NULL,
      NULL,
      0,
      1.956343,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1.081867,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0.213259,
      NULL,
      NULL,
      NULL,
      NULL,
      0.439433,
      6.682361,
      4,
      7,
      1.380399,
      0,
      0,
      NULL,
      NULL,
      NULL,
      1.872118,
      3.545399,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.714114,
      0.557598,
      0.934172,
      0.608747,
      0,
      1.063248,
      3,
      0.135249,
      NULL,
      3.675500,
      1,
      NULL,
      0,
      0.820617,
      1,
      1.243861,
      1,
      1.004632,
      1.220878,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.639247,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      4.017817,
      NULL,
      '22113',
      '',
      1,
      '',
      '',
      NULL,
      0.161113,
      '',
      '',
      NULL,
      NULL,
      0.765693,
      1,
      3.701128,
      3.570604,
      NULL,
      1,
      0.341491,
      NULL);
commit;
end;
/


