set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7812239';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-12-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '343',
      '10210220',
      50.350240,
      30.871694,
      NULL,
      NULL,
      2,
      2,
      NULL,
      NULL,
      3,
      ' 1- 9-2000',
      34.555629,
      NULL,
      NULL,
      NULL,
      3.801761,
      1.208460,
      1,
      1.686118,
      1,
      2,
      2,
      0,
      0,
      0.539661,
      1.046558,
      1.220167,
      NULL,
      1.591955,
      1,
      0,
      1.002384,
      1,
      1.014886,
      NULL,
      0,
      NULL,
      1.528921,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.657784,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.449652,
      NULL,
      0.196266,
      0.157361,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      9.932506,
      10.858181,
      NULL,
      1,
      3,
      0,
      1.085301,
      NULL,
      0,
      0.519198,
      0.158999,
      0.473647,
      0,
      1,
      0,
      2.467846,
      3,
      1,
      2,
      0,
      10,
      8,
      0,
      1,
      1,
      1,
      9.619026,
      1.061173,
      3.079317,
      6.307771,
      10.151349,
      6.975204,
      1,
      0.078879,
      9.686377,
      4,
      0,
      NULL,
      6.077612,
      6,
      3.552044,
      7.337211,
      NULL,
      8.905494,
      1,
      NULL,
      4.387506,
      NULL,
      0.978585,
      NULL,
      NULL,
      1,
      0.177756,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.671016,
      0,
      0,
      1.060700,
      NULL,
      0,
      1.929912,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.887263,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1.693411,
      0.760912,
      1.126599,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.661424,
      NULL,
      0.283098,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.162053,
      NULL,
      0,
      0,
      0.191769,
      0.720831,
      1,
      NULL,
      1,
      2,
      NULL,
      NULL,
      0.714155,
      0.053509,
      0,
      1,
      1.346365,
      0.769819,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      5.174777,
      '00344',
      '03431',
      '',
      1,
      '',
      '',
      NULL,
      0.133944,
      '',
      NULL,
      '',
      3.907976,
      2,
      2.963477,
      1,
      3.393256,
      0,
      2,
      1,
      NULL);
commit;
end;
/


